// $ANTLR 2.7.4: "ACIItem.g" -> "AntlrACIItemParser.java"$

/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */


package org.apache.directory.shared.ldap.aci;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Enumeration;

import javax.naming.directory.Attribute;
import javax.naming.NamingException;

import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParserImpl;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationModifier;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryAndOptionalComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryComponentsMonitor;
import org.apache.directory.shared.ldap.util.NamespaceTools;
import org.apache.directory.shared.ldap.util.NoDuplicateKeysMap;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.constants.SchemaConstants;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;

/**
 * The antlr generated ACIItem parser.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class AntlrACIItemParser extends antlr.LLkParser       implements AntlrACIItemParserTokenTypes
 {

    private static final Logger log = LoggerFactory.getLogger( AntlrACIItemParser.class );
    
    // subordinate parser instances
    private final FilterParserImpl filterParser = new FilterParserImpl();
    
    private boolean isNormalizing = false;
    NameComponentNormalizer normalizer;
    
    // nonshared global data needed to avoid extensive pass/return stuff
    // these are only used by three first order components
    private String m_identificationTag;
    private AuthenticationLevel m_authenticationLevel;
    private int m_aciPrecedence;
    
    private boolean isItemFirstACIItem;
    
    // shared global data needed to avoid extensive pass/return stuff
    private Set m_protectedItems;
    private Map m_protectedItemsMap;
    private Set m_userClasses;
    private Map m_userClassesMap;
    private Set m_itemPermissions;
    private int m_precedence;
    private Set m_grantsAndDenials;
    private Set m_userPermissions;
    private Map oidsMap;
    
    private Set chopBeforeExclusions;
    private Set chopAfterExclusions;
    private SubtreeSpecificationModifier ssModifier = null;
    
    private ComponentsMonitor mainACIItemComponentsMonitor;
    private ComponentsMonitor itemPermissionComponentsMonitor;
    private ComponentsMonitor userPermissionComponentsMonitor;
    private ComponentsMonitor subtreeSpecificationComponentsMonitor;
    
    
    /**
     * Creates a (normalizing) subordinate DnParser for parsing Names.
     * This method MUST be called for each instance while we cannot do
     * constructor overloading for this class.
     *
     * @return the DnParser to be used for parsing Names
     */
    public void init( Map oidsMap )
    {
    	this.oidsMap = oidsMap;
    }

    /**
     * Sets the NameComponentNormalizer for this parser's dnParser.
     */
    public void setNormalizer(NameComponentNormalizer normalizer)
    {
        this.normalizer = normalizer;
        this.isNormalizing = true;
    }

    private int token2Integer( Token token ) throws RecognitionException
    {
        int i = 0;
        
        try
        {
            i = Integer.parseInt( token.getText());
        }
        catch ( NumberFormatException e )
        {
            throw new RecognitionException( "Value of INTEGER token " +
                                            token.getText() +
                                            " cannot be converted to an Integer" );
        }
        
        return i;
    }

protected AntlrACIItemParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemParser(TokenBuffer tokenBuf) {
  this(tokenBuf,1);
}

protected AntlrACIItemParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public AntlrACIItemParser(TokenStream lexer) {
  this(lexer,1);
}

public AntlrACIItemParser(ParserSharedInputState state) {
  super(state,1);
  tokenNames = _tokenNames;
}

	public final  ACIItem  wrapperEntryPoint() throws RecognitionException, TokenStreamException {
		 ACIItem l_ACIItem ;
		
		
		log.debug( "entered wrapperEntryPoint()" );
		l_ACIItem = null;
		
		
		{
		_loop105:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop105;
			}
			
		} while (true);
		}
		l_ACIItem=theACIItem();
		{
		_loop107:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop107;
			}
			
		} while (true);
		}
		match(Token.EOF_TYPE);
		return l_ACIItem ;
	}
	
	public final  ACIItem  theACIItem() throws RecognitionException, TokenStreamException {
		 ACIItem l_ACIItem ;
		
		
		log.debug( "entered theACIItem()" );
		l_ACIItem = null;
		mainACIItemComponentsMonitor = new MandatoryComponentsMonitor( 
		new String [] { "identificationTag", "precedence", "authenticationLevel", "itemOrUserFirst" } );
		
		
		match(OPEN_CURLY);
		{
		_loop110:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop110;
			}
			
		} while (true);
		}
		mainACIItemComponent();
		{
		_loop112:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop112;
			}
			
		} while (true);
		}
		{
		_loop118:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop115:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop115;
					}
					
				} while (true);
				}
				mainACIItemComponent();
				{
				_loop117:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop117;
					}
					
				} while (true);
				}
			}
			else {
				break _loop118;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !mainACIItemComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( "Missing mandatory ACIItem components: " 
		+ mainACIItemComponentsMonitor.getRemainingComponents() );
		}
		
		if ( isItemFirstACIItem )
		{
		l_ACIItem = new ItemFirstACIItem(
		m_identificationTag,
		m_precedence,
		m_authenticationLevel,
		m_protectedItems,
		m_itemPermissions );
		}
		else
		{
		l_ACIItem = new UserFirstACIItem(
		m_identificationTag,
		m_aciPrecedence,
		m_authenticationLevel,
		m_userClasses,
		m_userPermissions );
		}
		
		
		return l_ACIItem ;
	}
	
	public final void mainACIItemComponent() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered mainACIItemComponent()" );
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_identificationTag:
			{
				aci_identificationTag();
				
				mainACIItemComponentsMonitor.useComponent( "identificationTag" );
				
				break;
			}
			case ID_precedence:
			{
				aci_precedence();
				
				mainACIItemComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_authenticationLevel:
			{
				aci_authenticationLevel();
				
				mainACIItemComponentsMonitor.useComponent( "authenticationLevel" );
				
				break;
			}
			case ID_itemOrUserFirst:
			{
				aci_itemOrUserFirst();
				
				mainACIItemComponentsMonitor.useComponent( "itemOrUserFirst" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void aci_identificationTag() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered aci_identificationTag()" );
		
		
		match(ID_identificationTag);
		{
		int _cnt122=0;
		_loop122:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt122>=1 ) { break _loop122; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt122++;
		} while (true);
		}
		token = LT(1);
		match(SAFEUTF8STRING);
		
		m_identificationTag = token.getText();
		
	}
	
	public final void aci_precedence() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered aci_precedence()" );
		
		
		precedence();
		
		m_aciPrecedence = m_precedence;
		
	}
	
	public final void aci_authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered aci_authenticationLevel()" );
		
		
		match(ID_authenticationLevel);
		{
		int _cnt129=0;
		_loop129:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt129>=1 ) { break _loop129; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt129++;
		} while (true);
		}
		authenticationLevel();
	}
	
	public final void aci_itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered aci_itemOrUserFirst()" );
		
		
		match(ID_itemOrUserFirst);
		{
		int _cnt133=0;
		_loop133:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt133>=1 ) { break _loop133; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt133++;
		} while (true);
		}
		itemOrUserFirst();
	}
	
	public final void precedence() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered precedence()" );
		
		
		match(ID_precedence);
		{
		int _cnt126=0;
		_loop126:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt126>=1 ) { break _loop126; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt126++;
		} while (true);
		}
		token = LT(1);
		match(INTEGER);
		
		m_precedence = token2Integer( token );
		if( m_precedence < 0 || m_precedence > 255 )
		{
		throw new RecognitionException( "Expecting INTEGER token having an Integer value between 0 and 255, found " + m_precedence );
		}
		
	}
	
	public final void authenticationLevel() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered authenticationLevel()" );
		
		
		switch ( LA(1)) {
		case ID_none:
		{
			match(ID_none);
			
			m_authenticationLevel = AuthenticationLevel.NONE;
			
			break;
		}
		case ID_simple:
		{
			match(ID_simple);
			
			m_authenticationLevel = AuthenticationLevel.SIMPLE;
			
			break;
		}
		case ID_strong:
		{
			match(ID_strong);
			
			m_authenticationLevel = AuthenticationLevel.STRONG;
			
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemOrUserFirst() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered itemOrUserFirst()" );
		
		
		switch ( LA(1)) {
		case ID_itemFirst:
		{
			itemFirst();
			break;
		}
		case ID_userFirst:
		{
			userFirst();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void itemFirst() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered itemFirst()" );
		
		
		match(ID_itemFirst);
		{
		_loop137:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop137;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop139:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop139;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop141:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop141;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_protectedItems:
		{
			protectedItems();
			{
			_loop144:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop144;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop146:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop146;
				}
				
			} while (true);
			}
			itemPermissions();
			break;
		}
		case ID_itemPermissions:
		{
			itemPermissions();
			{
			_loop148:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop148;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop150:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop150;
				}
				
			} while (true);
			}
			protectedItems();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop152:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop152;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		isItemFirstACIItem = true;
		
	}
	
	public final void userFirst() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered userFirst()" );
		
		
		match(ID_userFirst);
		{
		_loop155:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop155;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop157:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop157;
			}
			
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop159:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop159;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_userClasses:
		{
			userClasses();
			{
			_loop162:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop162;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop164:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop164;
				}
				
			} while (true);
			}
			userPermissions();
			break;
		}
		case ID_userPermissions:
		{
			userPermissions();
			{
			_loop166:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop166;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop168:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop168;
				}
				
			} while (true);
			}
			userClasses();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop170:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop170;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		isItemFirstACIItem = false;
		
	}
	
	public final void protectedItems() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered protectedItems()" );
		m_protectedItemsMap = new NoDuplicateKeysMap();
		
		
		try {      // for error handling
			match(ID_protectedItems);
			{
			_loop173:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop173;
				}
				
			} while (true);
			}
			match(OPEN_CURLY);
			{
			_loop175:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop175;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ATTRIBUTE_VALUE_CANDIDATE:
			case RANGE_OF_VALUES_CANDIDATE:
			case ID_entry:
			case ID_allUserAttributeTypes:
			case ID_attributeType:
			case ID_allAttributeValues:
			case ID_allUserAttributeTypesAndValues:
			case ID_selfValue:
			case ID_maxValueCount:
			case ID_maxImmSub:
			case ID_restrictedBy:
			case ID_classes:
			{
				protectedItem();
				{
				_loop178:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop178;
					}
					
				} while (true);
				}
				{
				_loop184:
				do {
					if ((LA(1)==SEP)) {
						match(SEP);
						{
						_loop181:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop181;
							}
							
						} while (true);
						}
						protectedItem();
						{
						_loop183:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop183;
							}
							
						} while (true);
						}
					}
					else {
						break _loop184;
					}
					
				} while (true);
				}
				break;
			}
			case CLOSE_CURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(CLOSE_CURLY);
			
			m_protectedItems = new HashSet( m_protectedItemsMap.values() );
			
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( "Protected Items cannot be duplicated. " + e.getMessage() );
			
		}
	}
	
	public final void itemPermissions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered itemPermissions()" );
		m_itemPermissions = new HashSet();
		ItemPermission l_itemPermission = null;
		
		
		match(ID_itemPermissions);
		{
		int _cnt289=0;
		_loop289:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt289>=1 ) { break _loop289; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt289++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop291:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop291;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			l_itemPermission=itemPermission();
			{
			_loop294:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop294;
				}
				
			} while (true);
			}
			
			m_itemPermissions.add( l_itemPermission );
			
			{
			_loop300:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop297:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop297;
						}
						
					} while (true);
					}
					l_itemPermission=itemPermission();
					{
					_loop299:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop299;
						}
						
					} while (true);
					}
					
					m_itemPermissions.add( l_itemPermission );
					
				}
				else {
					break _loop300;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void userClasses() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered userClasses()" );
		m_userClassesMap = new NoDuplicateKeysMap();
		
		
		try {      // for error handling
			match(ID_userClasses);
			{
			int _cnt330=0;
			_loop330:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt330>=1 ) { break _loop330; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt330++;
			} while (true);
			}
			match(OPEN_CURLY);
			{
			_loop332:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop332;
				}
				
			} while (true);
			}
			{
			switch ( LA(1)) {
			case ID_allUsers:
			case ID_thisEntry:
			case ID_name:
			case ID_userGroup:
			case ID_subtree:
			{
				userClass();
				{
				_loop335:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop335;
					}
					
				} while (true);
				}
				{
				_loop341:
				do {
					if ((LA(1)==SEP)) {
						match(SEP);
						{
						_loop338:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop338;
							}
							
						} while (true);
						}
						userClass();
						{
						_loop340:
						do {
							if ((LA(1)==SP)) {
								match(SP);
							}
							else {
								break _loop340;
							}
							
						} while (true);
						}
					}
					else {
						break _loop341;
					}
					
				} while (true);
				}
				break;
			}
			case CLOSE_CURLY:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(CLOSE_CURLY);
			
			m_userClasses  = new HashSet( m_userClassesMap.values() );
			
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( "User Classes cannot be duplicated. " + e.getMessage() );
			
		}
	}
	
	public final void userPermissions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered userPermissions()" );
		m_userPermissions = new HashSet();
		UserPermission l_userPermission = null;
		
		
		match(ID_userPermissions);
		{
		int _cnt386=0;
		_loop386:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt386>=1 ) { break _loop386; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt386++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop388:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop388;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case OPEN_CURLY:
		{
			l_userPermission=userPermission();
			{
			_loop391:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop391;
				}
				
			} while (true);
			}
			
			m_userPermissions.add( l_userPermission );
			
			{
			_loop397:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop394:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop394;
						}
						
					} while (true);
					}
					l_userPermission=userPermission();
					{
					_loop396:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop396;
						}
						
					} while (true);
					}
					
					m_userPermissions.add( l_userPermission );
					
				}
				else {
					break _loop397;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void protectedItem() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered protectedItem()" );
		
		
		switch ( LA(1)) {
		case ID_entry:
		{
			entry();
			break;
		}
		case ID_allUserAttributeTypes:
		{
			allUserAttributeTypes();
			break;
		}
		case ID_attributeType:
		{
			attributeType();
			break;
		}
		case ID_allAttributeValues:
		{
			allAttributeValues();
			break;
		}
		case ID_allUserAttributeTypesAndValues:
		{
			allUserAttributeTypesAndValues();
			break;
		}
		case ATTRIBUTE_VALUE_CANDIDATE:
		{
			attributeValue();
			break;
		}
		case ID_selfValue:
		{
			selfValue();
			break;
		}
		case RANGE_OF_VALUES_CANDIDATE:
		{
			rangeOfValues();
			break;
		}
		case ID_maxValueCount:
		{
			maxValueCount();
			break;
		}
		case ID_maxImmSub:
		{
			maxImmSub();
			break;
		}
		case ID_restrictedBy:
		{
			restrictedBy();
			break;
		}
		case ID_classes:
		{
			classes();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void entry() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered entry()" );  
		
		
		match(ID_entry);
		
		m_protectedItemsMap.put( "entry", ProtectedItem.ENTRY );
		
	}
	
	public final void allUserAttributeTypes() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered allUserAttributeTypes()" );
		
		
		match(ID_allUserAttributeTypes);
		
		m_protectedItemsMap.put( "allUserAttributeTypes", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES );
		
	}
	
	public final void attributeType() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered attributeType()" );
		Set l_attributeTypeSet = null;
		
		
		match(ID_attributeType);
		{
		int _cnt190=0;
		_loop190:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt190>=1 ) { break _loop190; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt190++;
		} while (true);
		}
		l_attributeTypeSet=attributeTypeSet();
		
		m_protectedItemsMap.put( "attributeType", new ProtectedItem.AttributeType( l_attributeTypeSet ) );
		
	}
	
	public final void allAttributeValues() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered allAttributeValues()" );
		Set l_attributeTypeSet = null;
		
		
		match(ID_allAttributeValues);
		{
		int _cnt193=0;
		_loop193:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt193>=1 ) { break _loop193; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt193++;
		} while (true);
		}
		l_attributeTypeSet=attributeTypeSet();
		
		m_protectedItemsMap.put( "allAttributeValues", new ProtectedItem.AllAttributeValues( l_attributeTypeSet ) );
		
	}
	
	public final void allUserAttributeTypesAndValues() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered allUserAttributeTypesAndValues()" );
		
		
		match(ID_allUserAttributeTypesAndValues);
		
		m_protectedItemsMap.put( "allUserAttributeTypesAndValues", ProtectedItem.ALL_USER_ATTRIBUTE_TYPES_AND_VALUES );
		
	}
	
	public final void attributeValue() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered attributeValue()" );
		String attributeTypeAndValue = null;
		String attributeType = null;
		String attributeValue = null;
		Set attributeSet = new HashSet();
		
		
		try {      // for error handling
			token = LT(1);
			match(ATTRIBUTE_VALUE_CANDIDATE);
			
			// A Dn can be considered as a set of attributeTypeAndValues
			// So, parse the set as a Dn and extract each attributeTypeAndValue
			LdapDN attributeTypeAndValueSetAsDn = new LdapDN( token.getText() );
			if ( oidsMap != null )
			{        
			attributeTypeAndValueSetAsDn.normalize( oidsMap );
			}
			Enumeration attributeTypeAndValueSet = attributeTypeAndValueSetAsDn.getAll();
			while ( attributeTypeAndValueSet.hasMoreElements() )
			{
			attributeTypeAndValue = ( String ) attributeTypeAndValueSet.nextElement();
			attributeType = NamespaceTools.getRdnAttribute( attributeTypeAndValue );
			attributeValue = NamespaceTools.getRdnValue( attributeTypeAndValue );
			attributeSet.add( new AttributeImpl( attributeType, attributeValue ) );
			log.debug( "An attributeTypeAndValue from the set: " + attributeType + "=" +  attributeValue);
			}
			m_protectedItemsMap.put( "attributeValue", new ProtectedItem.AttributeValue( attributeSet ) );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( "dnParser failed for " + token.getText() + " , " + e.getMessage() );
			
		}
	}
	
	public final void selfValue() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered selfValue()" );
		Set l_attributeTypeSet = null;
		
		
		match(ID_selfValue);
		{
		int _cnt198=0;
		_loop198:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt198>=1 ) { break _loop198; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt198++;
		} while (true);
		}
		l_attributeTypeSet=attributeTypeSet();
		
		m_protectedItemsMap.put( "sefValue", new ProtectedItem.SelfValue( l_attributeTypeSet ) );
		
	}
	
	public final void rangeOfValues() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered rangeOfValues()" );
		
		
		try {      // for error handling
			token = LT(1);
			match(RANGE_OF_VALUES_CANDIDATE);
			
			m_protectedItemsMap.put( "rangeOfValues",
			new ProtectedItem.RangeOfValues(
			filterParser.parse( token.getText() ) ) );
			log.debug( "filterParser parsed " + token.getText() );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( "filterParser failed. " + e.getMessage() );
			
		}
	}
	
	public final void maxValueCount() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered maxValueCount()" );
		ProtectedItem.MaxValueCountItem l_maxValueCount = null;
		Set maxValueCountSet = new HashSet();
		
		
		match(ID_maxValueCount);
		{
		int _cnt202=0;
		_loop202:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt202>=1 ) { break _loop202; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt202++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop204:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop204;
			}
			
		} while (true);
		}
		l_maxValueCount=aMaxValueCount();
		{
		_loop206:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop206;
			}
			
		} while (true);
		}
		
		maxValueCountSet.add( l_maxValueCount );
		
		{
		_loop212:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop209:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop209;
					}
					
				} while (true);
				}
				l_maxValueCount=aMaxValueCount();
				{
				_loop211:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop211;
					}
					
				} while (true);
				}
				
				maxValueCountSet.add( l_maxValueCount );
				
			}
			else {
				break _loop212;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		m_protectedItemsMap.put( "maxValueCount", new ProtectedItem.MaxValueCount( maxValueCountSet ) );
		
	}
	
	public final void maxImmSub() throws RecognitionException, TokenStreamException {
		
		Token  token = null;
		
		log.debug( "entered maxImmSub()" );
		
		
		match(ID_maxImmSub);
		{
		int _cnt237=0;
		_loop237:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt237>=1 ) { break _loop237; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt237++;
		} while (true);
		}
		token = LT(1);
		match(INTEGER);
		
		
		m_protectedItemsMap.put( "maxImmSub",
		new ProtectedItem.MaxImmSub(
		token2Integer( token ) ) );
		
	}
	
	public final void restrictedBy() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered restrictedBy()" );
		ProtectedItem.RestrictedByItem l_restrictedValue = null;
		Set l_restrictedBy = new HashSet();
		
		
		match(ID_restrictedBy);
		{
		int _cnt240=0;
		_loop240:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt240>=1 ) { break _loop240; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt240++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop242:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop242;
			}
			
		} while (true);
		}
		l_restrictedValue=restrictedValue();
		{
		_loop244:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop244;
			}
			
		} while (true);
		}
		
		l_restrictedBy.add( l_restrictedValue );
		
		{
		_loop250:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop247:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop247;
					}
					
				} while (true);
				}
				l_restrictedValue=restrictedValue();
				{
				_loop249:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop249;
					}
					
				} while (true);
				}
				
				l_restrictedBy.add( l_restrictedValue );
				
			}
			else {
				break _loop250;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		m_protectedItemsMap.put( "restrictedBy", new ProtectedItem.RestrictedBy( l_restrictedBy ) );
		
	}
	
	public final void classes() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered classes()" );
		ExprNode l_classes = null;
		
		
		match(ID_classes);
		{
		int _cnt286=0;
		_loop286:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt286>=1 ) { break _loop286; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt286++;
		} while (true);
		}
		l_classes=refinement();
		
		m_protectedItemsMap.put( "classes", new ProtectedItem.Classes( l_classes ) );
		
	}
	
	public final  Set  attributeTypeSet() throws RecognitionException, TokenStreamException {
		 Set l_attributeTypeSet ;
		
		
		log.debug( "entered attributeTypeSet()" );
		String l_oid = null;
		l_attributeTypeSet = new HashSet();
		
		
		match(OPEN_CURLY);
		{
		_loop275:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop275;
			}
			
		} while (true);
		}
		l_oid=oid();
		{
		_loop277:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop277;
			}
			
		} while (true);
		}
		
		l_attributeTypeSet.add( l_oid );
		
		{
		_loop283:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop280:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop280;
					}
					
				} while (true);
				}
				l_oid=oid();
				{
				_loop282:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop282;
					}
					
				} while (true);
				}
				
				l_attributeTypeSet.add( l_oid );
				
			}
			else {
				break _loop283;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		return l_attributeTypeSet ;
	}
	
	public final  ProtectedItem.MaxValueCountItem  aMaxValueCount() throws RecognitionException, TokenStreamException {
		 ProtectedItem.MaxValueCountItem l_maxValueCount ;
		
		Token  token1 = null;
		Token  token2 = null;
		
		log.debug( "entered aMaxValueCount()" );
		l_maxValueCount = null;
		String l_oid = null;
		Token token = null;
		
		
		match(OPEN_CURLY);
		{
		_loop215:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop215;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt218=0;
			_loop218:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt218>=1 ) { break _loop218; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt218++;
			} while (true);
			}
			l_oid=oid();
			{
			_loop220:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop220;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop222:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop222;
				}
				
			} while (true);
			}
			match(ID_maxCount);
			{
			int _cnt224=0;
			_loop224:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt224>=1 ) { break _loop224; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt224++;
			} while (true);
			}
			token1 = LT(1);
			match(INTEGER);
			token = token1;
			break;
		}
		case ID_maxCount:
		{
			match(ID_maxCount);
			{
			int _cnt226=0;
			_loop226:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt226>=1 ) { break _loop226; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt226++;
			} while (true);
			}
			token2 = LT(1);
			match(INTEGER);
			{
			_loop228:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop228;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop230:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop230;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt232=0;
			_loop232:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt232>=1 ) { break _loop232; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt232++;
			} while (true);
			}
			l_oid=oid();
			token = token2;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop234:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop234;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		l_maxValueCount = new ProtectedItem.MaxValueCountItem( l_oid, token2Integer( token ) );
		
		return l_maxValueCount ;
	}
	
	public final  String  oid() throws RecognitionException, TokenStreamException {
		 String result ;
		
		
		log.debug( "entered oid()" );
		result = null;
		Token token = null;
		
		
		token = LT( 1 );
		{
		switch ( LA(1)) {
		case DESCR:
		{
			match(DESCR);
			break;
		}
		case NUMERICOID:
		{
			match(NUMERICOID);
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		
		result = token.getText();
		log.debug( "recognized an oid: " + result );
		
		return result ;
	}
	
	public final  ProtectedItem.RestrictedByItem  restrictedValue() throws RecognitionException, TokenStreamException {
		 ProtectedItem.RestrictedByItem l_restrictedValue ;
		
		
		log.debug( "entered restrictedValue()" );
		String typeOid = null;
		String valuesInOid = null;
		l_restrictedValue = null;
		
		
		match(OPEN_CURLY);
		{
		_loop253:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop253;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_type:
		{
			match(ID_type);
			{
			int _cnt256=0;
			_loop256:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt256>=1 ) { break _loop256; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt256++;
			} while (true);
			}
			typeOid=oid();
			{
			_loop258:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop258;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop260:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop260;
				}
				
			} while (true);
			}
			match(ID_valuesIn);
			{
			int _cnt262=0;
			_loop262:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt262>=1 ) { break _loop262; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt262++;
			} while (true);
			}
			valuesInOid=oid();
			break;
		}
		case ID_valuesIn:
		{
			match(ID_valuesIn);
			{
			int _cnt264=0;
			_loop264:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt264>=1 ) { break _loop264; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt264++;
			} while (true);
			}
			valuesInOid=oid();
			{
			_loop266:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop266;
				}
				
			} while (true);
			}
			match(SEP);
			{
			_loop268:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop268;
				}
				
			} while (true);
			}
			match(ID_type);
			{
			int _cnt270=0;
			_loop270:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					if ( _cnt270>=1 ) { break _loop270; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt270++;
			} while (true);
			}
			typeOid=oid();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		{
		_loop272:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop272;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		l_restrictedValue = new ProtectedItem.RestrictedByItem( typeOid, valuesInOid );
		
		return l_restrictedValue ;
	}
	
	public final  ExprNode  refinement() throws RecognitionException, TokenStreamException {
		 ExprNode node ;
		
		
		log.debug( "entered refinement()" );
		node = null;
		
		
		switch ( LA(1)) {
		case ID_item:
		{
			node=item();
			break;
		}
		case ID_and:
		{
			node=and();
			break;
		}
		case ID_or:
		{
			node=or();
			break;
		}
		case ID_not:
		{
			node=not();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return node ;
	}
	
	public final  ItemPermission  itemPermission() throws RecognitionException, TokenStreamException {
		 ItemPermission l_itemPermission ;
		
		
		log.debug( "entered itemPermission()" );
		l_itemPermission = null;
		itemPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor( 
		new String [] { "userClasses", "grantsAndDenials" }, new String [] { "precedence" } );
		
		
		match(OPEN_CURLY);
		{
		_loop303:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop303;
			}
			
		} while (true);
		}
		anyItemPermission();
		{
		_loop305:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop305;
			}
			
		} while (true);
		}
		{
		_loop311:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop308:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop308;
					}
					
				} while (true);
				}
				anyItemPermission();
				{
				_loop310:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop310;
					}
					
				} while (true);
				}
			}
			else {
				break _loop311;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !itemPermissionComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( "Missing mandatory itemPermission components: " 
		+ itemPermissionComponentsMonitor.getRemainingComponents() );
		}
		
		l_itemPermission = new ItemPermission( m_precedence, m_grantsAndDenials, m_userClasses );
		
		return l_itemPermission ;
	}
	
	public final void anyItemPermission() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_precedence:
			{
				precedence();
				
				itemPermissionComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_userClasses:
			{
				userClasses();
				
				itemPermissionComponentsMonitor.useComponent( "userClasses" );
				
				break;
			}
			case ID_grantsAndDenials:
			{
				grantsAndDenials();
				
				itemPermissionComponentsMonitor.useComponent( "grantsAndDenials" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void grantsAndDenials() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered grantsAndDenials()" );
		m_grantsAndDenials = new HashSet();
		GrantAndDenial l_grantAndDenial = null;
		
		
		match(ID_grantsAndDenials);
		{
		int _cnt315=0;
		_loop315:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt315>=1 ) { break _loop315; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt315++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop317:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop317;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_grantAdd:
		case ID_denyAdd:
		case ID_grantDiscloseOnError:
		case ID_denyDiscloseOnError:
		case ID_grantRead:
		case ID_denyRead:
		case ID_grantRemove:
		case ID_denyRemove:
		case ID_grantBrowse:
		case ID_denyBrowse:
		case ID_grantExport:
		case ID_denyExport:
		case ID_grantImport:
		case ID_denyImport:
		case ID_grantModify:
		case ID_denyModify:
		case ID_grantRename:
		case ID_denyRename:
		case ID_grantReturnDN:
		case ID_denyReturnDN:
		case ID_grantCompare:
		case ID_denyCompare:
		case ID_grantFilterMatch:
		case ID_denyFilterMatch:
		case ID_grantInvoke:
		case ID_denyInvoke:
		{
			l_grantAndDenial=grantAndDenial();
			{
			_loop320:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop320;
				}
				
			} while (true);
			}
			
			if ( !m_grantsAndDenials.add( l_grantAndDenial ))
			{
			throw new RecognitionException( "Duplicated GrantAndDenial bit: " + l_grantAndDenial );
			}
			
			{
			_loop326:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop323:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop323;
						}
						
					} while (true);
					}
					l_grantAndDenial=grantAndDenial();
					{
					_loop325:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop325;
						}
						
					} while (true);
					}
					
					if ( !m_grantsAndDenials.add( l_grantAndDenial ))
					{
					throw new RecognitionException( "Duplicated GrantAndDenial bit: " + l_grantAndDenial );
					}
					
				}
				else {
					break _loop326;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final  GrantAndDenial  grantAndDenial() throws RecognitionException, TokenStreamException {
		 GrantAndDenial l_grantAndDenial ;
		
		
		log.debug( "entered grantAndDenialsBit()" );
		l_grantAndDenial = null;
		
		
		switch ( LA(1)) {
		case ID_grantAdd:
		{
			match(ID_grantAdd);
			l_grantAndDenial = GrantAndDenial.GRANT_ADD;
			break;
		}
		case ID_denyAdd:
		{
			match(ID_denyAdd);
			l_grantAndDenial = GrantAndDenial.DENY_ADD;
			break;
		}
		case ID_grantDiscloseOnError:
		{
			match(ID_grantDiscloseOnError);
			l_grantAndDenial = GrantAndDenial.GRANT_DISCLOSE_ON_ERROR;
			break;
		}
		case ID_denyDiscloseOnError:
		{
			match(ID_denyDiscloseOnError);
			l_grantAndDenial = GrantAndDenial.DENY_DISCLOSE_ON_ERROR;
			break;
		}
		case ID_grantRead:
		{
			match(ID_grantRead);
			l_grantAndDenial = GrantAndDenial.GRANT_READ;
			break;
		}
		case ID_denyRead:
		{
			match(ID_denyRead);
			l_grantAndDenial = GrantAndDenial.DENY_READ;
			break;
		}
		case ID_grantRemove:
		{
			match(ID_grantRemove);
			l_grantAndDenial = GrantAndDenial.GRANT_REMOVE;
			break;
		}
		case ID_denyRemove:
		{
			match(ID_denyRemove);
			l_grantAndDenial = GrantAndDenial.DENY_REMOVE;
			break;
		}
		case ID_grantBrowse:
		{
			match(ID_grantBrowse);
			l_grantAndDenial = GrantAndDenial.GRANT_BROWSE;
			break;
		}
		case ID_denyBrowse:
		{
			match(ID_denyBrowse);
			l_grantAndDenial = GrantAndDenial.DENY_BROWSE;
			break;
		}
		case ID_grantExport:
		{
			match(ID_grantExport);
			l_grantAndDenial = GrantAndDenial.GRANT_EXPORT;
			break;
		}
		case ID_denyExport:
		{
			match(ID_denyExport);
			l_grantAndDenial = GrantAndDenial.DENY_EXPORT;
			break;
		}
		case ID_grantImport:
		{
			match(ID_grantImport);
			l_grantAndDenial = GrantAndDenial.GRANT_IMPORT;
			break;
		}
		case ID_denyImport:
		{
			match(ID_denyImport);
			l_grantAndDenial = GrantAndDenial.DENY_IMPORT;
			break;
		}
		case ID_grantModify:
		{
			match(ID_grantModify);
			l_grantAndDenial = GrantAndDenial.GRANT_MODIFY;
			break;
		}
		case ID_denyModify:
		{
			match(ID_denyModify);
			l_grantAndDenial = GrantAndDenial.DENY_MODIFY;
			break;
		}
		case ID_grantRename:
		{
			match(ID_grantRename);
			l_grantAndDenial = GrantAndDenial.GRANT_RENAME;
			break;
		}
		case ID_denyRename:
		{
			match(ID_denyRename);
			l_grantAndDenial = GrantAndDenial.DENY_RENAME;
			break;
		}
		case ID_grantReturnDN:
		{
			match(ID_grantReturnDN);
			l_grantAndDenial = GrantAndDenial.GRANT_RETURN_DN;
			break;
		}
		case ID_denyReturnDN:
		{
			match(ID_denyReturnDN);
			l_grantAndDenial = GrantAndDenial.DENY_RETURN_DN;
			break;
		}
		case ID_grantCompare:
		{
			match(ID_grantCompare);
			l_grantAndDenial = GrantAndDenial.GRANT_COMPARE;
			break;
		}
		case ID_denyCompare:
		{
			match(ID_denyCompare);
			l_grantAndDenial = GrantAndDenial.DENY_COMPARE;
			break;
		}
		case ID_grantFilterMatch:
		{
			match(ID_grantFilterMatch);
			l_grantAndDenial = GrantAndDenial.GRANT_FILTER_MATCH;
			break;
		}
		case ID_denyFilterMatch:
		{
			match(ID_denyFilterMatch);
			l_grantAndDenial = GrantAndDenial.DENY_FILTER_MATCH;
			break;
		}
		case ID_grantInvoke:
		{
			match(ID_grantInvoke);
			l_grantAndDenial = GrantAndDenial.GRANT_INVOKE;
			break;
		}
		case ID_denyInvoke:
		{
			match(ID_denyInvoke);
			l_grantAndDenial = GrantAndDenial.DENY_INVOKE;
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		return l_grantAndDenial ;
	}
	
	public final void userClass() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered userClasses()" );
		
		
		switch ( LA(1)) {
		case ID_allUsers:
		{
			allUsers();
			break;
		}
		case ID_thisEntry:
		{
			thisEntry();
			break;
		}
		case ID_name:
		{
			name();
			break;
		}
		case ID_userGroup:
		{
			userGroup();
			break;
		}
		case ID_subtree:
		{
			subtree();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void allUsers() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered allUsers()" );
		
		
		match(ID_allUsers);
		
		m_userClassesMap.put( "allUsers", UserClass.ALL_USERS );
		
	}
	
	public final void thisEntry() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered thisEntry()" );
		
		
		match(ID_thisEntry);
		
		m_userClassesMap.put( "thisEntry", UserClass.THIS_ENTRY );
		
	}
	
	public final void name() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered name()" );
		Set l_name = new HashSet();
		LdapDN l_distinguishedName = null;
		
		
		match(ID_name);
		{
		int _cnt347=0;
		_loop347:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt347>=1 ) { break _loop347; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt347++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop349:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop349;
			}
			
		} while (true);
		}
		l_distinguishedName=distinguishedName();
		{
		_loop351:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop351;
			}
			
		} while (true);
		}
		
		l_name.add( l_distinguishedName );
		
		{
		_loop357:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop354:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop354;
					}
					
				} while (true);
				}
				l_distinguishedName=distinguishedName();
				{
				_loop356:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop356;
					}
					
				} while (true);
				}
				
				l_name.add( l_distinguishedName );
				
			}
			else {
				break _loop357;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		m_userClassesMap.put( "name", new UserClass.Name( l_name ) );
		
	}
	
	public final void userGroup() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered userGroup()" );
		Set l_userGroup = new HashSet();
		LdapDN l_distinguishedName = null;
		
		
		match(ID_userGroup);
		{
		int _cnt360=0;
		_loop360:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt360>=1 ) { break _loop360; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt360++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop362:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop362;
			}
			
		} while (true);
		}
		l_distinguishedName=distinguishedName();
		{
		_loop364:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop364;
			}
			
		} while (true);
		}
		
		l_userGroup.add( l_distinguishedName );
		
		{
		_loop370:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop367:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop367;
					}
					
				} while (true);
				}
				l_distinguishedName=distinguishedName();
				{
				_loop369:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop369;
					}
					
				} while (true);
				}
				
				l_userGroup.add( l_distinguishedName );
				
			}
			else {
				break _loop370;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		m_userClassesMap.put( "userGroup", new UserClass.UserGroup( l_userGroup ) );
		
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered subtree()" );
		Set l_subtree = new HashSet();
		SubtreeSpecification l_subtreeSpecification = null;    
		
		
		match(ID_subtree);
		{
		int _cnt373=0;
		_loop373:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt373>=1 ) { break _loop373; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt373++;
		} while (true);
		}
		match(OPEN_CURLY);
		{
		_loop375:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop375;
			}
			
		} while (true);
		}
		l_subtreeSpecification=subtreeSpecification();
		{
		_loop377:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop377;
			}
			
		} while (true);
		}
		
		l_subtree.add( l_subtreeSpecification );
		
		{
		_loop383:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop380:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop380;
					}
					
				} while (true);
				}
				l_subtreeSpecification=subtreeSpecification();
				{
				_loop382:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop382;
					}
					
				} while (true);
				}
				
				l_subtree.add( l_subtreeSpecification );
				
			}
			else {
				break _loop383;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		m_userClassesMap.put( "subtree", new UserClass.Subtree( l_subtree ) );
		
	}
	
	public final  LdapDN  distinguishedName() throws RecognitionException, TokenStreamException {
		 LdapDN name ;
		
		Token  token = null;
		
		log.debug( "entered distinguishedName()" );
		name = null;
		
		
		try {      // for error handling
			token = LT(1);
			match(SAFEUTF8STRING);
			
			name = new LdapDN( token.getText() );
			if ( oidsMap != null )
			{
			name.normalize( oidsMap );
			}
			log.debug( "recognized a DistinguishedName: " + token.getText() );
			
		}
		catch (Exception e) {
			
			throw new RecognitionException( "dnParser failed for " + token.getText() + " " + e.getMessage() );
			
		}
		return name ;
	}
	
	public final SubtreeSpecification  subtreeSpecification() throws RecognitionException, TokenStreamException {
		SubtreeSpecification ss;
		
		
		log.debug( "entered subtreeSpecification()" );
		// clear out ss, ssModifier, chopBeforeExclusions and chopAfterExclusions
		// in case something is left from the last parse
		ss = null;
		ssModifier = new SubtreeSpecificationModifier();
		chopBeforeExclusions = new HashSet();
		chopAfterExclusions = new HashSet();
		subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor( 
		new String [] { "base", "specificExclusions", "minimum", "maximum" } );
		
		
		match(OPEN_CURLY);
		{
		_loop412:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop412;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_base:
		case ID_specificExclusions:
		case ID_minimum:
		case ID_maximum:
		{
			subtreeSpecificationComponent();
			{
			_loop415:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop415;
				}
				
			} while (true);
			}
			{
			_loop421:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop418:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop418;
						}
						
					} while (true);
					}
					subtreeSpecificationComponent();
					{
					_loop420:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop420;
						}
						
					} while (true);
					}
				}
				else {
					break _loop421;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
		
		ss = ssModifier.getSubtreeSpecification();
		
		return ss;
	}
	
	public final  UserPermission  userPermission() throws RecognitionException, TokenStreamException {
		 UserPermission l_userPermission ;
		
		
		log.debug( "entered userPermission()" );
		l_userPermission = null;
		userPermissionComponentsMonitor = new MandatoryAndOptionalComponentsMonitor( 
		new String [] { "protectedItems", "grantsAndDenials" }, new String [] { "precedence" } );
		
		
		match(OPEN_CURLY);
		{
		_loop400:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop400;
			}
			
		} while (true);
		}
		anyUserPermission();
		{
		_loop402:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop402;
			}
			
		} while (true);
		}
		{
		_loop408:
		do {
			if ((LA(1)==SEP)) {
				match(SEP);
				{
				_loop405:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop405;
					}
					
				} while (true);
				}
				anyUserPermission();
				{
				_loop407:
				do {
					if ((LA(1)==SP)) {
						match(SP);
					}
					else {
						break _loop407;
					}
					
				} while (true);
				}
			}
			else {
				break _loop408;
			}
			
		} while (true);
		}
		match(CLOSE_CURLY);
		
		if ( !userPermissionComponentsMonitor.finalStateValid() )
		{
		throw new RecognitionException( "Missing mandatory userPermission components: " 
		+ userPermissionComponentsMonitor.getRemainingComponents() );
		}
		
		l_userPermission = new UserPermission( m_aciPrecedence, m_grantsAndDenials, m_protectedItems );
		
		return l_userPermission ;
	}
	
	public final void anyUserPermission() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_precedence:
			{
				precedence();
				
				userPermissionComponentsMonitor.useComponent( "precedence" );
				
				break;
			}
			case ID_protectedItems:
			{
				protectedItems();
				
				userPermissionComponentsMonitor.useComponent( "protectedItems" );
				
				break;
			}
			case ID_grantsAndDenials:
			{
				grantsAndDenials();
				
				userPermissionComponentsMonitor.useComponent( "grantsAndDenials" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered subtreeSpecification()" );
		
		
		try {      // for error handling
			switch ( LA(1)) {
			case ID_base:
			{
				ss_base();
				
				subtreeSpecificationComponentsMonitor.useComponent( "base" );
				
				break;
			}
			case ID_specificExclusions:
			{
				ss_specificExclusions();
				
				subtreeSpecificationComponentsMonitor.useComponent( "specificExclusions" );
				
				break;
			}
			case ID_minimum:
			{
				ss_minimum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "minimum" );
				
				break;
			}
			case ID_maximum:
			{
				ss_maximum();
				
				subtreeSpecificationComponentsMonitor.useComponent( "maximum" );
				
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
		}
		catch (IllegalArgumentException e) {
			
			throw new RecognitionException( e.getMessage() );
			
		}
	}
	
	public final void ss_base() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_base()" );
		LdapDN base = null;
		
		
		match(ID_base);
		{
		int _cnt425=0;
		_loop425:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt425>=1 ) { break _loop425; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt425++;
		} while (true);
		}
		base=distinguishedName();
		
		ssModifier.setBase( base );
		
	}
	
	public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_specificExclusions()" );
		
		
		match(ID_specificExclusions);
		{
		int _cnt428=0;
		_loop428:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt428>=1 ) { break _loop428; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt428++;
		} while (true);
		}
		specificExclusions();
		
		ssModifier.setChopBeforeExclusions( chopBeforeExclusions );
		ssModifier.setChopAfterExclusions( chopAfterExclusions );
		
	}
	
	public final void ss_minimum() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_minimum()" );
		int minimum = 0;
		
		
		match(ID_minimum);
		{
		int _cnt454=0;
		_loop454:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt454>=1 ) { break _loop454; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt454++;
		} while (true);
		}
		minimum=baseDistance();
		
		ssModifier.setMinBaseDistance( minimum );
		
	}
	
	public final void ss_maximum() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered ss_maximum()" );
		int maximum = 0;
		
		
		match(ID_maximum);
		{
		int _cnt457=0;
		_loop457:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				if ( _cnt457>=1 ) { break _loop457; } else {throw new NoViableAltException(LT(1), getFilename());}
			}
			
			_cnt457++;
		} while (true);
		}
		maximum=baseDistance();
		
		ssModifier.setMaxBaseDistance( maximum );
		
	}
	
	public final void specificExclusions() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered specificExclusions()" );
		
		
		match(OPEN_CURLY);
		{
		_loop431:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop431;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_chopBefore:
		case ID_chopAfter:
		{
			specificExclusion();
			{
			_loop434:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop434;
				}
				
			} while (true);
			}
			{
			_loop440:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop437:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop437;
						}
						
					} while (true);
					}
					specificExclusion();
					{
					_loop439:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop439;
						}
						
					} while (true);
					}
				}
				else {
					break _loop440;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
	}
	
	public final void specificExclusion() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered specificExclusion()" );
		
		
		switch ( LA(1)) {
		case ID_chopBefore:
		{
			chopBefore();
			break;
		}
		case ID_chopAfter:
		{
			chopAfter();
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
	}
	
	public final void chopBefore() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered chopBefore()" );
		LdapDN chopBeforeExclusion = null;
		
		
		match(ID_chopBefore);
		{
		_loop444:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop444;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop446:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop446;
			}
			
		} while (true);
		}
		chopBeforeExclusion=distinguishedName();
		
		chopBeforeExclusions.add( chopBeforeExclusion );
		
	}
	
	public final void chopAfter() throws RecognitionException, TokenStreamException {
		
		
		log.debug( "entered chopAfter()" );
		LdapDN chopAfterExclusion = null;
		
		
		match(ID_chopAfter);
		{
		_loop449:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop449;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop451:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop451;
			}
			
		} while (true);
		}
		chopAfterExclusion=distinguishedName();
		
		chopAfterExclusions.add( chopAfterExclusion );
		
	}
	
	public final  int  baseDistance() throws RecognitionException, TokenStreamException {
		 int distance ;
		
		Token  token = null;
		
		log.debug( "entered baseDistance()" );
		distance = 0;
		
		
		token = LT(1);
		match(INTEGER);
		
		distance = token2Integer( token );
		
		return distance ;
	}
	
	public final  LeafNode  item() throws RecognitionException, TokenStreamException {
		 LeafNode node ;
		
		
		log.debug( "entered item()" );
		node = null;
		String l_oid = null;
		
		
		match(ID_item);
		{
		_loop465:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop465;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop467:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop467;
			}
			
		} while (true);
		}
		l_oid=oid();
		
		node = new SimpleNode( SchemaConstants.OBJECT_CLASS_AT , l_oid , AssertionEnum.EQUALITY );
		
		return node ;
	}
	
	public final  BranchNode  and() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		log.debug( "entered and()" );
		node = null;
		ArrayList children = null; 
		
		
		match(ID_and);
		{
		_loop470:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop470;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop472:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop472;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new BranchNode( AssertionEnum.AND , children );
		
		return node ;
	}
	
	public final  BranchNode  or() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		log.debug( "entered or()" );
		node = null;
		ArrayList children = null; 
		
		
		match(ID_or);
		{
		_loop475:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop475;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop477:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop477;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new BranchNode( AssertionEnum.OR , children );
		
		return node ;
	}
	
	public final  BranchNode  not() throws RecognitionException, TokenStreamException {
		 BranchNode node ;
		
		
		log.debug( "entered not()" );
		node = null;
		ArrayList children = null;
		
		
		match(ID_not);
		{
		_loop480:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop480;
			}
			
		} while (true);
		}
		match(COLON);
		{
		_loop482:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop482;
			}
			
		} while (true);
		}
		children=refinements();
		
		node = new BranchNode( AssertionEnum.NOT , children );
		
		return node ;
	}
	
	public final  ArrayList  refinements() throws RecognitionException, TokenStreamException {
		 ArrayList children ;
		
		
		log.debug( "entered refinements()" );
		children = null;
		ExprNode child = null;
		ArrayList tempChildren = new ArrayList();
		
		
		match(OPEN_CURLY);
		{
		_loop485:
		do {
			if ((LA(1)==SP)) {
				match(SP);
			}
			else {
				break _loop485;
			}
			
		} while (true);
		}
		{
		switch ( LA(1)) {
		case ID_item:
		case ID_and:
		case ID_or:
		case ID_not:
		{
			child=refinement();
			{
			_loop488:
			do {
				if ((LA(1)==SP)) {
					match(SP);
				}
				else {
					break _loop488;
				}
				
			} while (true);
			}
			
			tempChildren.add( child );
			
			{
			_loop494:
			do {
				if ((LA(1)==SEP)) {
					match(SEP);
					{
					_loop491:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop491;
						}
						
					} while (true);
					}
					child=refinement();
					{
					_loop493:
					do {
						if ((LA(1)==SP)) {
							match(SP);
						}
						else {
							break _loop493;
						}
						
					} while (true);
					}
					
					tempChildren.add( child );
					
				}
				else {
					break _loop494;
				}
				
			} while (true);
			}
			break;
		}
		case CLOSE_CURLY:
		{
			break;
		}
		default:
		{
			throw new NoViableAltException(LT(1), getFilename());
		}
		}
		}
		match(CLOSE_CURLY);
		
		children = tempChildren;
		
		return children ;
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"ATTRIBUTE_VALUE_CANDIDATE",
		"RANGE_OF_VALUES_CANDIDATE",
		"SP",
		"OPEN_CURLY",
		"SEP",
		"CLOSE_CURLY",
		"\"identificationTag\"",
		"SAFEUTF8STRING",
		"\"precedence\"",
		"INTEGER",
		"\"authenticationLevel\"",
		"\"none\"",
		"\"simple\"",
		"\"strong\"",
		"\"itemOrUserFirst\"",
		"\"itemFirst\"",
		"COLON",
		"\"userFirst\"",
		"\"protectedItems\"",
		"\"entry\"",
		"\"allUserAttributeTypes\"",
		"\"attributeType\"",
		"\"allAttributeValues\"",
		"\"allUserAttributeTypesAndValues\"",
		"\"selfValue\"",
		"\"maxValueCount\"",
		"\"type\"",
		"\"maxCount\"",
		"\"maxImmSub\"",
		"\"restrictedBy\"",
		"\"valuesIn\"",
		"\"classes\"",
		"\"itemPermissions\"",
		"\"grantsAndDenials\"",
		"\"grantAdd\"",
		"\"denyAdd\"",
		"\"grantDiscloseOnError\"",
		"\"denyDiscloseOnError\"",
		"\"grantRead\"",
		"\"denyRead\"",
		"\"grantRemove\"",
		"\"denyRemove\"",
		"\"grantBrowse\"",
		"\"denyBrowse\"",
		"\"grantExport\"",
		"\"denyExport\"",
		"\"grantImport\"",
		"\"denyImport\"",
		"\"grantModify\"",
		"\"denyModify\"",
		"\"grantRename\"",
		"\"denyRename\"",
		"\"grantReturnDN\"",
		"\"denyReturnDN\"",
		"\"grantCompare\"",
		"\"denyCompare\"",
		"\"grantFilterMatch\"",
		"\"denyFilterMatch\"",
		"\"grantInvoke\"",
		"\"denyInvoke\"",
		"\"userClasses\"",
		"\"allUsers\"",
		"\"thisEntry\"",
		"\"name\"",
		"\"userGroup\"",
		"\"subtree\"",
		"\"userPermissions\"",
		"\"base\"",
		"\"specificExclusions\"",
		"\"chopBefore\"",
		"\"chopAfter\"",
		"\"minimum\"",
		"\"maximum\"",
		"DESCR",
		"NUMERICOID",
		"\"item\"",
		"\"and\"",
		"\"or\"",
		"\"not\"",
		"\"FALSE\"",
		"\"TRUE\"",
		"\"level\"",
		"\"basicLevels\"",
		"\"localQualifier\"",
		"\"signed\"",
		"\"rangeOfValues\"",
		"\"specificationFilter\"",
		"SAFEUTF8CHAR",
		"DIGIT",
		"LDIGIT",
		"ALPHA",
		"HYPHEN",
		"DOT",
		"INTEGER_OR_NUMERICOID",
		"FILTER",
		"FILTER_VALUE"
	};
	
	
	}
