/*
 * Copyright (c) 2006-2011 Nuxeo SA (http://nuxeo.com/) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nuxeo - initial API and implementation
 *
 * $Id$
 */

package org.nuxeo.ecm.core.schema.types;

import java.io.Serializable;

/**
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 *
 */
public interface TypeHelper extends Serializable {

    Object decode(String input);

    String encode(Object input);

    Object normalize(Object value);

    <T> T convertTo(Object value, Class<T> toType);

    boolean isTypeCompatible(Class<?> type);

    boolean isValueCompatible(Object value);

    Object newInstance();

}
