package org.jboss.seam.ui.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.jboss.seam.ui.component.UIDecorate;

public class HtmlDecorate extends UIDecorate{

final public static  String COMPONENT_FAMILY = "org.jboss.seam.ui.Decorate";

final public static  String COMPONENT_TYPE = "org.jboss.seam.ui.Decorate";

/*
* Id of the input field to decorate
*/
private  String _for = null;

/*
* CSS style(s) is/are to be applied when this component is rendered
*/
private  String _style = null;

/*
* Corresponds to the HTML class attribute
*/
private  String _styleClass = null;

/*
* XHTML template to use to decorate the input field
*/
private  String _template = null;


public HtmlDecorate(){
setRendererType("org.jboss.seam.ui.DecorateRenderer");
}

public String getFor(){
return _for;
}

public void setFor(String _for){
this._for = _for;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public String getTemplate(){
	if (this._template != null) {
		return this._template;
	}
	ValueExpression ve = getValueExpression("template");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTemplate(String _template){
this._template = _template;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[5];
state[0] = super.saveState(context);
state[1] = _for;
state[2] = _style;
state[3] = _styleClass;
state[4] = _template;
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_for = (String)states[1];;
		_style = (String)states[2];;
		_styleClass = (String)states[3];;
		_template = (String)states[4];;
	
}

}
