/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.server.schema.bootstrap;


import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.server.schema.registries.*;


/**
 * A producer of schema objectClass definations for the apache schema.  This
 * code has been automatically generated using schema files in the OpenLDAP
 * format along with the directory plugin for maven.  This has been done
 * to facilitate OpenLDAP schema interoperability.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 * @version $Rev$
 */
public class ApacheObjectClassProducer extends AbstractBootstrapProducer
{

    public ApacheObjectClassProducer()
    {
        super( ProducerTypeEnum.OBJECT_CLASS_PRODUCER );
    }


    // ------------------------------------------------------------------------
    // BootstrapProducer Methods
    // ------------------------------------------------------------------------


    /**
     * @see BootstrapProducer#produce(Registries, ProducerCallback)
     */
    public void produce( Registries registries, ProducerCallback cb )
        throws NamingException
    {
        ArrayList<String> array = new ArrayList<String>();
        BootstrapObjectClass objectClass;

        
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.1 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.1", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "prefNodeName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "prefNode" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.1", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.2 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.2", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "prescriptiveACI" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "accessControlSubentry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.2", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.3", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "apacheServicePid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "apacheServiceFactoryPid" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "apacheServiceConfiguration" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.3", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.4 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.4", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "apacheServicePid" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "apacheFactoryConfiguration" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.4", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.5", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "apacheCatalogEntryBaseDn" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "apacheCatalogEntryName" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "apacheCatalogEntry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.5", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.6 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.6", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "windowsFilePath" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "windowsFile" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.6", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.7 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.7", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "unixFilePath" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "unixFile" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.7", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.8", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "fullyQualifiedJavaClassName" );
        array.add( "javaClassByteCode" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaClass" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.8", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.5.3 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.5.3", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.ABSTRACT );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "storedProcLangId" );
        array.add( "storedProcUnitName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "storedProcUnit" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.5.3", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.5.5 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.5.5", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "storedProcUnit" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "javaByteCode" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaStoredProcUnit" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.5.5", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.5.8 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.5.8", registries );
        objectClass.setObsolete( false );

        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "storedProcUnit" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "javaxScriptLangId" );
        array.add( "javaxScriptCode" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "javaxScriptStoredProcUnit" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.5.8", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.2.28 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.2.28", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "Used to track a subentry associated with trigger areas" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "prescriptiveTriggerSpecification" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "triggerExecutionSubentry" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.2.28", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.9 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.9", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "RFC2252 extension for controlling subschema (sub)entry in ApacheDS" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.AUXILIARY );
        
        // set superior objectClasses
        array.clear();
        array.add( "subschema" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        array.add( "comparators" );
        array.add( "normalizers" );
        array.add( "syntaxCheckers" );
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "apacheSubschema" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.9", objectClass );

 
        // --------------------------------------------------------------------
        // ObjectClass 1.3.6.1.4.1.18060.0.4.1.3.10 
        // --------------------------------------------------------------------

        objectClass = newObjectClass( "1.3.6.1.4.1.18060.0.4.1.3.10", registries );
        objectClass.setObsolete( false );

        objectClass.setDescription( "a special entry tracking schema modification attributes" );
        // set the objectclass type
        objectClass.setType( ObjectClassTypeEnum.STRUCTURAL );
        
        // set superior objectClasses
        array.clear();
        array.add( "top" );
        objectClass.setSuperClassIds( array.toArray( EMPTY ) );
        
        // set must list
        array.clear();
        array.add( "cn" );
        array.add( "subschemaSubentryName" );
        array.add( "schemaModifyTimestamp" );
        array.add( "schemaModifiersName" );
        objectClass.setMustListIds( array.toArray( EMPTY ) );
        
        // set may list
        array.clear();
        objectClass.setMayListIds( array.toArray( EMPTY ) );
        
        // set names
        array.clear();
        array.add( "schemaModificationAttributes" );
        objectClass.setNames( array.toArray( EMPTY ) );
        cb.schemaObjectProduced( this, "1.3.6.1.4.1.18060.0.4.1.3.10", objectClass );

    }
}
