/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.core.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.jbpm.JbpmTaskListService;
import org.nuxeo.ecm.platform.jbpm.TaskList;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class JbpmTaskListServiceImpl
extends DefaultComponent
implements JbpmTaskListService {
    private static final String JBPMLISTS = "tasklists";

    public TaskList createTaskList(CoreSession session, String listName) throws ClientException {
        DocumentModel listRoot = JbpmTaskListServiceImpl.getOrCreateListRoot(session);
        DocumentModel taskListDoc = session.createDocumentModel(listRoot.getPathAsString(), listName, "TaskList");
        taskListDoc = session.createDocument(taskListDoc);
        taskListDoc = session.saveDocument(taskListDoc);
        session.save();
        return (TaskList)taskListDoc.getAdapter(TaskList.class);
    }

    public void saveTaskList(CoreSession session, TaskList list) throws ClientException {
        DocumentModel listDoc = list.getDocument();
        session.saveDocument(listDoc);
        session.save();
    }

    public TaskList getTaskList(CoreSession session, String listUUId) throws ClientException {
        TaskList list = null;
        if (session.exists((DocumentRef)new IdRef(listUUId))) {
            DocumentModel listDoc = session.getDocument((DocumentRef)new IdRef(listUUId));
            list = (TaskList)listDoc.getAdapter(TaskList.class);
        }
        return list;
    }

    public void deleteTaskList(CoreSession session, String listUUId) throws ClientException {
        if (session.exists((DocumentRef)new IdRef(listUUId))) {
            session.removeDocument((DocumentRef)new IdRef(listUUId));
            session.save();
        }
    }

    private static DocumentModel getUserWorkspace(CoreSession session) throws ClientException {
        UserWorkspaceService uws = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel userWorkspace = uws.getCurrentUserPersonalWorkspace(session, null);
        return userWorkspace;
    }

    private static DocumentModel getOrCreateListRoot(CoreSession session) throws ClientException {
        String path = String.format("%s/%s", JbpmTaskListServiceImpl.getUserWorkspace(session).getPathAsString(), JBPMLISTS);
        DocumentModel taskListRootDoc = null;
        if (session.exists((DocumentRef)new PathRef(path))) {
            taskListRootDoc = session.getDocument((DocumentRef)new PathRef(path));
        } else {
            taskListRootDoc = session.createDocumentModel(JbpmTaskListServiceImpl.getUserWorkspace(session).getPathAsString(), JBPMLISTS, "TaskLists");
            taskListRootDoc = session.createDocument(taskListRootDoc);
            session.saveDocument(taskListRootDoc);
            session.save();
        }
        return taskListRootDoc;
    }

    public List<TaskList> getTaskLists(CoreSession session) throws ClientException {
        ArrayList<TaskList> taskLists = new ArrayList<TaskList>();
        DocumentModel listRoot = JbpmTaskListServiceImpl.getOrCreateListRoot(session);
        DocumentModelList docs = session.getChildren(listRoot.getRef(), "TaskList");
        for (DocumentModel documentModel : docs) {
            taskLists.add((TaskList)documentModel.getAdapter(TaskList.class));
        }
        return taskLists;
    }
}

