/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.jbpm.test;

import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.nuxeo.ecm.core.api.SimplePrincipal;

public abstract class AbstractProcessDefinitionTest
extends TestCase {
    protected final List<String> bob_list = Collections.singletonList("bob");
    protected final List<String> trudy_list = Collections.singletonList("trudy");
    protected JbpmConfiguration configuration;
    protected ProcessDefinition pd;
    protected JbpmContext jbpmContext;

    public AbstractProcessDefinitionTest() {
    }

    public AbstractProcessDefinitionTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        InputStream isConf = ((Object)((Object)this)).getClass().getResourceAsStream(this.getConfigurationResource());
        this.configuration = JbpmConfiguration.parseInputStream((InputStream)isConf);
        AbstractProcessDefinitionTest.assertNotNull((Object)this.configuration);
        this.jbpmContext = this.configuration.createJbpmContext();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(this.getProcessDefinitionResource());
        AbstractProcessDefinitionTest.assertNotNull((Object)is);
        this.pd = ProcessDefinition.parseXmlInputStream((InputStream)is);
        AbstractProcessDefinitionTest.assertNotNull((Object)this.pd);
    }

    protected void tearDown() throws Exception {
        this.jbpmContext.close();
    }

    public String getConfigurationResource() {
        return "/config/test-jbpm.cfg.xml";
    }

    public abstract String getProcessDefinitionResource();

    public List<Principal> getPrincipalsList() {
        ArrayList<Principal> pList = new ArrayList<Principal>();
        pList.add((Principal)new SimplePrincipal("bob"));
        pList.add((Principal)new SimplePrincipal("trudy"));
        return pList;
    }
}

