/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.functionaltests.pages.usermanagement.compat;

import org.nuxeo.functionaltests.Required;
import org.nuxeo.functionaltests.pages.usermanagement.compat.UserCreationFormPage;
import org.nuxeo.functionaltests.pages.usermanagement.compat.UserViewTabSubPage;
import org.nuxeo.functionaltests.pages.usermanagement.compat.UsersGroupsBasePage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class UsersTabSubPage
extends UsersGroupsBasePage {
    @Required
    @FindBy(linkText="Create a new user")
    WebElement createNewUserLink;
    @FindBy(name="searchForm:searchText")
    WebElement searchInput;
    @FindBy(name="searchForm:searchButton")
    WebElement searchButton;

    public UsersTabSubPage(WebDriver driver) {
        super(driver);
    }

    public UserCreationFormPage getUserCreatePage() {
        this.createNewUserLink.click();
        return this.asPage(UserCreationFormPage.class);
    }

    public UsersTabSubPage searchUser(String query) {
        this.searchInput.clear();
        this.searchInput.sendKeys(new CharSequence[]{query});
        this.searchButton.click();
        return this.asPage(UsersTabSubPage.class);
    }

    public boolean isUserFound(String username) {
        try {
            this.driver.findElement(By.linkText((String)username));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public UserViewTabSubPage viewUser(String username) {
        this.driver.findElement(By.linkText((String)username)).click();
        return this.asPage(UserViewTabSubPage.class);
    }
}

