/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort")
public class DiscoveryService
extends AbstractService
implements DiscoveryServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void getContentChanges(String repositoryId, javax.xml.ws.Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, CmisExtensionType extension, javax.xml.ws.Holder<CmisObjectListType> objects) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            Holder changeLogTokenHolder = Converter.convertHolder(changeLogToken);
            ObjectList changesList = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, Converter.convert((CmisExtensionType)extension));
            if (objects != null) {
                objects.value = Converter.convert((ObjectList)changesList);
            }
            Converter.setHolderValue((Holder)changeLogTokenHolder, changeLogToken);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public CmisObjectListType query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        CmisObjectListType cmisObjectListType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisObjectListType = Converter.convert((ObjectList)service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, (IncludeRelationships)Converter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, maxItems, skipCount, Converter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectListType;
    }
}

