/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.InverseReference;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.sql.SQLStaticFilter;
import org.nuxeo.ecm.directory.sql.TableReference;

@XObject(value="directory")
public class SQLDirectoryDescriptor {
    private static final Log log = LogFactory.getLog(SQLDirectoryDescriptor.class);
    protected static final char DEFAULT_CHARACTER_SEPARATOR = ',';
    private static final String[] SCRIPT_POLICIES = new String[]{"never", "on_missing_columns", "always"};
    private static final String DEFAULT_POLICY = "never";
    @XNode(value="@name")
    public String name;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="parentDirectory")
    public String parentDirectory;
    @XNode(value="dataSource")
    public String dataSourceName;
    @XNode(value="dbDriver")
    public String dbDriver;
    @XNode(value="dbUrl")
    public String dbUrl;
    @XNode(value="dbUser")
    public String dbUser;
    @XNode(value="dbPassword")
    public String dbPassword;
    @XNode(value="table")
    public String tableName;
    @XNodeList(value="init-dependencies/dependency", type=ArrayList.class, componentType=String.class)
    public List<String> initDependencies;
    @XNode(value="idField")
    public String idField;
    @XNode(value="dataFile")
    public String dataFileName;
    @XNode(value="dataFileCharacterSeparator", trim=false)
    public String dataFileCharacterSeparator = ",";
    public String createTablePolicy;
    public SubstringMatchType substringMatchType;
    @XNode(value="autoincrementIdField")
    public boolean autoincrementIdField;
    @XNode(value="readOnly")
    public Boolean readOnly = Boolean.FALSE;
    @XNode(value="passwordField")
    private String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNode(value="querySizeLimit")
    private int querySizeLimit;
    @XNodeList(value="references/tableReference", type=TableReference[].class, componentType=TableReference.class)
    private TableReference[] tableReferences;
    @XNodeList(value="references/inverseReference", type=InverseReference[].class, componentType=InverseReference.class)
    private InverseReference[] inverseReferences;
    @XNode(value="@remove")
    private boolean remove = false;
    @XNode(value="cacheTimeout")
    public int cacheTimeout = 0;
    @XNode(value="cacheMaxSize")
    public int cacheMaxSize = 0;
    @XNodeList(value="filters/staticFilter", type=SQLStaticFilter[].class, componentType=SQLStaticFilter.class)
    private SQLStaticFilter[] staticFilters;
    @XNode(value="nativeCase")
    public Boolean nativeCase;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setIdField(String idField) {
        this.idField = idField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public char getDataFileCharacterSeparator() {
        if (this.dataFileCharacterSeparator == null || this.dataFileCharacterSeparator.length() == 0) {
            log.info((Object)"Character separator not well set will take the default value, \",\"");
            return ',';
        }
        if (this.dataFileCharacterSeparator.length() > 1) {
            log.warn((Object)("More than one character found for character separator, will take the first one \"" + this.dataFileCharacterSeparator.charAt(0) + "\""));
        }
        return this.dataFileCharacterSeparator.charAt(0);
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public String getIdField() {
        return this.idField;
    }

    public String getCreateTablePolicy() {
        return this.createTablePolicy;
    }

    @XNode(value="createTablePolicy")
    public void setCreateTablePolicy(String createTablePolicy) throws DirectoryException {
        if (createTablePolicy == null) {
            this.createTablePolicy = DEFAULT_POLICY;
            return;
        }
        createTablePolicy = createTablePolicy.toLowerCase();
        boolean validPolicy = false;
        for (String policy : SCRIPT_POLICIES) {
            if (!createTablePolicy.equals(policy)) continue;
            validPolicy = true;
            break;
        }
        if (!validPolicy) {
            throw new DirectoryException("invalid value for createTablePolicy: " + createTablePolicy + ". It should be one of 'never', " + "'on_missing_columns',  or 'always'.");
        }
        this.createTablePolicy = createTablePolicy;
    }

    @XNode(value="substringMatchType")
    public void setSubstringMatchType(String substringMatchType) {
        if (substringMatchType != null) {
            try {
                this.substringMatchType = Enum.valueOf(SubstringMatchType.class, substringMatchType);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("Invalid substring match type: " + substringMatchType + ". Valid options: subinitial, subfinal, subany"));
                this.substringMatchType = SubstringMatchType.subinitial;
            }
        }
    }

    public Reference[] getInverseReferences() {
        return this.inverseReferences;
    }

    public Reference[] getTableReferences() {
        return this.tableReferences;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isAutoincrementIdField() {
        return this.autoincrementIdField;
    }

    public void setAutoincrementIdField(boolean autoincrementIdField) {
        this.autoincrementIdField = autoincrementIdField;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setInverseReferences(InverseReference[] inverseReferences) {
        this.inverseReferences = inverseReferences;
    }

    public void setDataFileName(String dataFile) {
        this.dataFileName = dataFile;
    }

    public void setTableReferences(TableReference[] tableReferences) {
        this.tableReferences = tableReferences;
    }

    public int getQuerySizeLimit() {
        return this.querySizeLimit;
    }

    public void setQuerySizeLimit(int querySizeLimit) {
        this.querySizeLimit = querySizeLimit;
    }

    public void setRemove(boolean delete) {
        this.remove = delete;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public SubstringMatchType getSubstringMatchType() {
        return this.substringMatchType == null ? SubstringMatchType.subinitial : this.substringMatchType;
    }

    public void setSubstringMatchType(SubstringMatchType substringMatchType) {
        this.substringMatchType = substringMatchType;
    }

    public SQLStaticFilter[] getStaticFilters() {
        if (this.staticFilters == null) {
            return new SQLStaticFilter[0];
        }
        return this.staticFilters;
    }

    public void merge(SQLDirectoryDescriptor other) {
        if (this.dbUser == null) {
            this.dbUser = other.dbUser;
        }
        if (this.dbPassword == null) {
            this.dbPassword = other.dbPassword;
        }
        if (this.dataSourceName == null) {
            this.dataSourceName = other.dataSourceName;
        }
        if (this.dbDriver == null) {
            this.dbDriver = other.dbDriver;
        }
        if (this.dbUrl == null) {
            this.dbUrl = other.dbUrl;
        }
        if (this.createTablePolicy == null) {
            this.createTablePolicy = other.createTablePolicy;
        }
        if (this.idField == null) {
            this.idField = other.idField;
        }
        if (this.readOnly == null) {
            this.readOnly = other.readOnly;
        }
        if (this.schemaName == null) {
            this.schemaName = other.schemaName;
        }
        if (this.parentDirectory == null) {
            this.parentDirectory = other.parentDirectory;
        }
        if (this.dataFileName == null) {
            this.dataFileName = other.dataFileName;
        }
        if (this.tableName == null) {
            this.tableName = other.tableName;
        }
        if (this.substringMatchType == null) {
            this.substringMatchType = other.substringMatchType;
        }
        if (this.passwordField == null) {
            this.passwordField = other.passwordField;
        }
        if (this.passwordHashAlgorithm == null) {
            this.passwordHashAlgorithm = other.passwordHashAlgorithm;
        }
        if (this.nativeCase == null) {
            this.nativeCase = other.nativeCase;
        }
        if (this.inverseReferences == null || this.inverseReferences.length == 0) {
            this.inverseReferences = other.inverseReferences;
        }
        if (this.tableReferences == null || this.tableReferences.length == 0) {
            this.tableReferences = other.tableReferences;
        }
    }

    public static enum SubstringMatchType {
        subinitial,
        subfinal,
        subany;

    }
}

