/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl.expressive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.util.ELUtils;
import org.richfaces.model.Field;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;
import org.richfaces.model.impl.expressive.Expression;
import org.richfaces.model.impl.expressive.JavaBeanWrapper;
import org.richfaces.model.impl.expressive.MethodBindingExpression;
import org.richfaces.model.impl.expressive.NullExpression;
import org.richfaces.model.impl.expressive.SimplePropertyExpression;
import org.richfaces.model.impl.expressive.ValueBindingExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWrapperFactory {
    private Expression[] expressions;
    private FacesContext context;
    private String var;
    private Object varValue;

    public ObjectWrapperFactory(FacesContext context, String var, SortOrder sortOrder) {
        this.context = context;
        Application application = context.getApplication();
        ELResolver resolver = application.getELResolver();
        ELContext elContext = context.getELContext();
        this.var = var;
        SortField[] sortFields = sortOrder.getFields();
        this.expressions = new Expression[sortFields.length];
        for (int i = 0; i < sortFields.length; ++i) {
            SortField field = sortFields[i];
            String name = field.getName();
            this.expressions[i] = ELUtils.isValueReference(name) ? new ValueBindingExpression(context, name, var) : (name.startsWith("j_id") ? new NullExpression(name) : new SimplePropertyExpression(name, elContext, resolver));
        }
    }

    public ObjectWrapperFactory(FacesContext context, String var, List<? extends Field> sortOrder) {
        this.context = context;
        Application application = context.getApplication();
        ELResolver resolver = application.getELResolver();
        ELContext elContext = context.getELContext();
        this.var = var;
        this.expressions = new Expression[sortOrder.size()];
        int i = 0;
        for (Field field : sortOrder) {
            Expression expression;
            javax.el.Expression elExpression = field.getExpression();
            if (elExpression instanceof ValueExpression) {
                String expressionString;
                ValueExpression valueExpression = (ValueExpression)elExpression;
                expression = valueExpression.isLiteralText() ? ((expressionString = valueExpression.getExpressionString()).startsWith("j_id") ? new NullExpression(expressionString) : new SimplePropertyExpression(expressionString, elContext, resolver)) : new ValueBindingExpression(context, valueExpression, var);
            } else if (elExpression instanceof MethodExpression) {
                expression = new MethodBindingExpression(context, (MethodExpression)elExpression);
            } else {
                throw new IllegalArgumentException();
            }
            this.expressions[i++] = expression;
        }
    }

    void convertList(List<? super Object> list, ObjectConvertor c) {
        int l = list.size();
        for (int i = 0; i < l; ++i) {
            Object o = list.get(i);
            list.set(i, c.convert(o));
        }
    }

    public List<? super Object> unwrapList(List<Object> list) {
        this.convertList(list, new ObjectConvertor(){

            public Object convert(Object o) {
                return ObjectWrapperFactory.this.unwrapObject(o);
            }
        });
        Map<String, Object> requestMap = this.getRequestMap();
        if (this.varValue == null) {
            requestMap.remove(this.var);
        } else {
            requestMap.put(this.var, this.varValue);
        }
        return list;
    }

    private Map<String, Object> getRequestMap() {
        ExternalContext externalContext = this.context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        return requestMap;
    }

    public Object unwrapObject(Object wrapper) {
        return ((JavaBeanWrapper)wrapper).getWrappedObject();
    }

    public List<Object> wrapList(List<Object> list) {
        this.varValue = this.getRequestMap().get(this.var);
        this.convertList(list, new ObjectConvertor(){

            public Object convert(Object o) {
                return ObjectWrapperFactory.this.wrapObject(o);
            }
        });
        return list;
    }

    public JavaBeanWrapper wrapObject(Object o) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            props.put(expression.getExpressionString(), expression.evaluate(o));
        }
        return new JavaBeanWrapper(o, props);
    }

    static interface ObjectConvertor {
        public Object convert(Object var1);
    }
}

