/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.List;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSequenceDataModel
extends ExtendedDataModel {
    private List<?> list;
    private int index;

    public ListSequenceDataModel(List<?> list) {
        this.setWrappedData(list);
    }

    public Object getRowKey() {
        if (this.index < 0) {
            return null;
        }
        return new Integer(this.index);
    }

    public void setRowKey(Object key) {
        if (null == key) {
            this.index = -1;
        } else {
            this.setRowIndex((Integer)key);
        }
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        SequenceRange seqRange = (SequenceRange)range;
        int rows = seqRange.getRows();
        int rowCount = this.list != null ? this.list.size() : -1;
        int currentRow = seqRange.getFirstRow();
        if (rows > 0) {
            rows += currentRow;
            rows = Math.min(rows, rowCount);
        } else {
            rows = rowCount;
        }
        while (currentRow < rows) {
            this.setRowIndex(currentRow);
            visitor.process(context, (Object)new Integer(currentRow), argument);
            ++currentRow;
        }
    }

    public int getRowCount() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public Object getRowData() {
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.list.get(this.index);
    }

    public int getRowIndex() {
        return this.index;
    }

    public Object getWrappedData() {
        return this.list;
    }

    public boolean isRowAvailable() {
        return this.list != null && 0 <= this.index && this.index < this.list.size();
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        this.index = rowIndex;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.list = null;
            this.setRowIndex(-1);
        } else {
            this.list = (List)data;
            this.setRowIndex(0);
        }
    }
}

