/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.jruby.util.ByteList;
import org.jvyamlb.Emitter;
import org.jvyamlb.EmitterException;
import org.jvyamlb.ParserImpl;
import org.jvyamlb.ScannerImpl;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLConfig;
import org.jvyamlb.events.AliasEvent;
import org.jvyamlb.events.CollectionEndEvent;
import org.jvyamlb.events.CollectionStartEvent;
import org.jvyamlb.events.DocumentEndEvent;
import org.jvyamlb.events.DocumentStartEvent;
import org.jvyamlb.events.Event;
import org.jvyamlb.events.MappingEndEvent;
import org.jvyamlb.events.MappingStartEvent;
import org.jvyamlb.events.NodeEvent;
import org.jvyamlb.events.ScalarEvent;
import org.jvyamlb.events.SequenceEndEvent;
import org.jvyamlb.events.SequenceStartEvent;
import org.jvyamlb.events.StreamEndEvent;
import org.jvyamlb.events.StreamStartEvent;

public class EmitterImpl
implements Emitter {
    private static final int STREAM_START = 0;
    private static final int FIRST_DOCUMENT_START = 1;
    private static final int DOCUMENT_ROOT = 2;
    private static final int NOTHING = 3;
    private static final int DOCUMENT_START = 4;
    private static final int DOCUMENT_END = 5;
    private static final int FIRST_FLOW_SEQUENCE_ITEM = 6;
    private static final int FLOW_SEQUENCE_ITEM = 7;
    private static final int FIRST_FLOW_MAPPING_KEY = 8;
    private static final int FLOW_MAPPING_SIMPLE_VALUE = 9;
    private static final int FLOW_MAPPING_VALUE = 10;
    private static final int FLOW_MAPPING_KEY = 11;
    private static final int BLOCK_SEQUENCE_ITEM = 12;
    private static final int FIRST_BLOCK_MAPPING_KEY = 13;
    private static final int BLOCK_MAPPING_SIMPLE_VALUE = 14;
    private static final int BLOCK_MAPPING_VALUE = 15;
    private static final int BLOCK_MAPPING_KEY = 16;
    private static final int FIRST_BLOCK_SEQUENCE_ITEM = 17;
    private static final EmitterState[] STATES = new EmitterState[18];
    private static final Map DEFAULT_TAG_PREFIXES_1_0;
    private static final Map DEFAULT_TAG_PREFIXES_1_1;
    private OutputStream stream;
    private YAMLConfig options;
    private EmitterEnvironment env;
    private static final Pattern HANDLE_FORMAT;
    private static final Pattern ANCHOR_FORMAT;
    private static final Pattern DOC_INDIC;
    private static final Pattern FIRST_SPACE;
    private static final String NULL_BL_T_LINEBR = "\u0000 \t\r\n";
    private static final String SPECIAL_INDIC = "#,[]{}#&*!|>'\"%@`";
    private static final String FLOW_INDIC = ",?[]{}";

    public EmitterImpl(OutputStream stream, YAMLConfig opts) {
        int propWidth;
        this.stream = stream;
        this.options = opts;
        this.env = new EmitterEnvironment();
        this.env.emitter = this;
        this.env.canonical = this.options.canonical();
        int propIndent = this.options.indent();
        if (propIndent >= 2 && propIndent < 10) {
            this.env.bestIndent = propIndent;
        }
        if ((propWidth = this.options.bestWidth()) != 0 && propWidth > this.env.bestIndent * 2) {
            this.env.bestWidth = propWidth;
        }
    }

    public YAMLConfig getOptions() {
        return this.options;
    }

    public void emit(Event event) throws IOException {
        this.env.events.add(event);
        while (!this.env.needMoreEvents()) {
            this.env.event = (Event)this.env.events.remove(0);
            STATES[this.env.state].expect(this.env);
            this.env.event = null;
        }
    }

    void writeStreamStart() {
    }

    void writeStreamEnd() throws IOException {
        this.flushStream();
    }

    void writeIndicator(ByteList indicator, boolean needWhitespace, boolean whitespace, boolean indentation) throws IOException {
        ByteList data = indicator;
        if (!this.env.whitespace && needWhitespace) {
            data.prepend((byte)32);
        }
        this.env.whitespace = whitespace;
        this.env.indentation = this.env.indentation && indentation;
        this.env.column += data.length();
        this.stream.write(data.bytes, 0, data.realSize);
    }

    void writeIndent() throws IOException {
        int indent = 0;
        if (this.env.indent != -1) {
            indent = this.env.indent;
        }
        if (!this.env.indentation || this.env.column > indent || this.env.column == indent && !this.env.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.env.column < indent) {
            this.env.whitespace = true;
            ByteList data = new ByteList();
            int j = indent - this.env.column;
            for (int i = 0; i < j; ++i) {
                data.append((byte)32);
            }
            this.env.column = indent;
            this.stream.write(data.bytes, 0, data.realSize);
        }
    }

    void writeVersionDirective(String version_text) throws IOException {
        this.stream.write(("%YAML " + version_text).getBytes());
        this.writeLineBreak(null);
    }

    void writeTagDirective(String handle, String prefix) throws IOException {
        this.stream.write(("%TAG " + handle + " " + prefix).getBytes());
        this.writeLineBreak(null);
    }

    void writeDoubleQuoted(ByteList text, boolean split) throws IOException {
        this.writeIndicator(ByteList.create("\""), true, false, false);
        int start = 0;
        ByteList data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ch = '\u0000';
            if (ending < text.length()) {
                ch = text.charAt(ending);
            }
            if (ch == '\u0000' || "\"\\".indexOf(ch) != -1 || ' ' > ch || ch > '~') {
                if (start < ending) {
                    data = (ByteList)text.subSequence(start, ending);
                    this.env.column += data.length();
                    this.stream.write(data.bytes, 0, data.realSize);
                    start = ending;
                }
                if (ch != '\u0000') {
                    if (YAML.ESCAPE_REPLACEMENTS.containsKey(new Character(ch))) {
                        data = ByteList.create("\\" + YAML.ESCAPE_REPLACEMENTS.get(new Character(ch)));
                    } else if (ch <= '\u00ff') {
                        String str = Integer.toString(ch, 16);
                        if (str.length() == 1) {
                            str = "0" + str;
                        }
                        data = ByteList.create("\\x" + str);
                    }
                    this.env.column += data.length();
                    this.stream.write(data.bytes, 0, data.realSize);
                    start = ending + 1;
                }
            }
            if (0 >= ending || ending >= text.length() - 1 || ch != ' ' && start < ending || this.env.column + (ending - start) <= this.env.bestWidth || !split) continue;
            if (start < ending) {
                data = (ByteList)text.subSequence(start, ending);
                data.append(32);
                data.append(92);
                start = ending + 1;
            } else {
                data = ByteList.create("\\");
            }
            this.env.column += data.length();
            this.stream.write(data.bytes, 0, data.realSize);
            this.writeIndent();
            this.env.whitespace = false;
            this.env.indentation = false;
            if (start >= text.length() + 1 || text.charAt(start) != ' ') continue;
            data = ByteList.create("\\");
            this.stream.write(data.bytes, 0, data.realSize);
        }
        this.writeIndicator(ByteList.create("\""), false, false, false);
    }

    void writeSingleQuoted(ByteList text, boolean split) throws IOException {
        this.writeIndicator(ByteList.create("'"), true, false, false);
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        char ceh = '\u0000';
        ByteList data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (spaces) {
                if (ceh == '\u0000' || ceh != ' ') {
                    if (start + 1 == ending && this.env.column > this.env.bestWidth && split && start != 0 && ending != text.length()) {
                        this.writeIndent();
                    } else {
                        data = (ByteList)text.subSequence(start, ending);
                        this.env.column += data.length();
                        this.stream.write(data.bytes, 0, data.realSize);
                    }
                    start = ending;
                }
            } else if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh) {
                    data = (ByteList)text.subSequence(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + cha));
                    }
                    this.writeIndent();
                    start = ending;
                }
            } else if ((ceh == '\u0000' || '\n' != ceh) && start < ending) {
                data = (ByteList)text.subSequence(start, ending);
                this.env.column += data.length();
                this.stream.write(data.bytes, 0, data.realSize);
                start = ending;
            }
            if (ceh == '\'') {
                data = ByteList.create("''");
                this.env.column += 2;
                this.stream.write(data.bytes, 0, data.realSize);
                start = ending + 1;
            }
            if (ceh == '\u0000') continue;
            spaces = ceh == ' ';
            breaks = ceh == '\n';
        }
        this.writeIndicator(ByteList.create("'"), false, false, false);
    }

    void writeFolded(ByteList text) throws IOException {
        String chomp = EmitterImpl.determineChomp(text);
        this.writeIndicator(ByteList.create(">" + chomp), true, false, false);
        this.writeIndent();
        boolean leadingSpace = false;
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        ByteList data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh) {
                    if (!leadingSpace && ceh != '\u0000' && ceh != ' ' && text.charAt(start) == '\n') {
                        this.writeLineBreak(null);
                    }
                    leadingSpace = ceh == ' ';
                    data = (ByteList)text.subSequence(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + cha));
                    }
                    if (ceh != '\u0000') {
                        this.writeIndent();
                    }
                    start = ending;
                }
            } else if (spaces) {
                if (ceh != ' ') {
                    if (start + 1 == ending && this.env.column > this.env.bestWidth) {
                        this.writeIndent();
                    } else {
                        data = (ByteList)text.subSequence(start, ending);
                        this.env.column += data.length();
                        this.stream.write(data.bytes, 0, data.realSize);
                    }
                    start = ending;
                }
            } else if (ceh == '\u0000' || ' ' == ceh || '\n' == ceh) {
                data = (ByteList)text.subSequence(start, ending);
                this.stream.write(data.bytes, 0, data.realSize);
                if (ceh == '\u0000') {
                    this.writeLineBreak(null);
                }
                start = ending;
            }
            if (ceh == '\u0000') continue;
            breaks = '\n' == ceh;
            spaces = ceh == ' ';
        }
    }

    void writeLiteral(ByteList text) throws IOException {
        String chomp = EmitterImpl.determineChomp(text);
        this.writeIndicator(ByteList.create("|" + chomp), true, false, false);
        this.writeIndent();
        boolean breaks = false;
        int start = 0;
        ByteList data = null;
        for (int ending = 0; ending <= text.length(); ++ending) {
            char ceh = '\u0000';
            if (ending < text.length()) {
                ceh = text.charAt(ending);
            }
            if (breaks) {
                if (ceh == '\u0000' || '\n' != ceh) {
                    data = (ByteList)text.subSequence(start, ending);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = data.charAt(i);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + cha));
                    }
                    if (ceh != '\u0000') {
                        this.writeIndent();
                    }
                    start = ending;
                }
            } else if (ceh == '\u0000' || '\n' == ceh) {
                data = (ByteList)text.subSequence(start, ending);
                this.stream.write(data.bytes, 0, data.realSize);
                if (ceh == '\u0000') {
                    this.writeLineBreak(null);
                }
                start = ending;
            }
            if (ceh == '\u0000') continue;
            breaks = '\n' == ceh;
        }
    }

    void writePlain(ByteList text, boolean split) throws IOException {
        if (text == null || text.realSize == 0) {
            return;
        }
        ByteList data = null;
        if (!this.env.whitespace) {
            ++this.env.column;
            this.stream.write(32);
        }
        this.env.whitespace = false;
        this.env.indentation = false;
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        for (int ending = 0; ending <= text.length(); ++ending) {
            int ceh = 0;
            if (ending < text.length()) {
                ceh = (char)(text.bytes[text.begin + ending] & 0xFF);
            }
            if (spaces) {
                if (ceh != 32) {
                    if (start + 1 == ending && this.env.column > this.env.bestWidth && split) {
                        this.writeIndent();
                        this.env.whitespace = false;
                        this.env.indentation = false;
                    } else {
                        data = new ByteList(text, start, ending - start);
                        this.env.column += data.length();
                        this.stream.write(data.bytes, 0, data.realSize);
                    }
                    start = ending;
                }
            } else if (breaks) {
                if (ceh != 10) {
                    if ((text.bytes[start] & 0xFF) == 10) {
                        this.writeLineBreak(null);
                    }
                    data = new ByteList(text, start, ending - start);
                    int j = data.length();
                    for (int i = 0; i < j; ++i) {
                        char cha = (char)(data.bytes[data.begin + i] & 0xFF);
                        if ('\n' == cha) {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(ByteList.create("" + cha));
                    }
                    this.writeIndent();
                    this.env.whitespace = false;
                    this.env.indentation = false;
                    start = ending;
                }
            } else if (ceh == 0 || 32 == ceh || 10 == ceh) {
                data = new ByteList(text, start, ending - start);
                this.env.column += data.length();
                this.stream.write(data.bytes, 0, data.realSize);
                start = ending;
            }
            if (ceh == 0) continue;
            spaces = ceh == 32;
            breaks = ceh == 10;
        }
    }

    void writeLineBreak(ByteList data) throws IOException {
        ByteList xdata = data;
        if (xdata == null) {
            xdata = this.env.bestLinebreak;
        }
        this.env.whitespace = true;
        this.env.indentation = true;
        ++this.env.line;
        this.env.column = 0;
        this.stream.write(xdata.bytes, 0, xdata.realSize);
    }

    void flushStream() throws IOException {
        this.stream.flush();
    }

    static String prepareVersion(int[] version) {
        if (version[0] != 1) {
            throw new EmitterException("unsupported YAML version: " + version[0] + "." + version[1]);
        }
        return "" + version[0] + "." + version[1];
    }

    static String prepareTagHandle(String handle) {
        if (handle == null || "".equals(handle)) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (handle.charAt(0) != '!' || handle.charAt(handle.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + handle);
        }
        if (!"!".equals(handle) && !HANDLE_FORMAT.matcher(handle).matches()) {
            throw new EmitterException("invalid syntax for tag handle: " + handle);
        }
        return handle;
    }

    static String prepareTagPrefix(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuffer chunks = new StringBuffer();
        int start = 0;
        int ending = 0;
        if (prefix.charAt(0) == '!') {
            ending = 1;
        }
        while (ending < prefix.length()) {
            ++ending;
        }
        if (start < ending) {
            chunks.append(prefix.substring(start, ending));
        }
        return chunks.toString();
    }

    static String prepareAnchor(String anchor) {
        if (anchor == null || "".equals(anchor)) {
            throw new EmitterException("anchor must not be empty");
        }
        if (!ANCHOR_FORMAT.matcher(anchor).matches()) {
            throw new EmitterException("invalid syntax for anchor: " + anchor);
        }
        return anchor;
    }

    String prepareTag(String tag) {
        int ending;
        if (tag == null || "".equals(tag)) {
            throw new EmitterException("tag must not be empty");
        }
        if (tag.equals("!")) {
            return tag;
        }
        String handle = null;
        String suffix = tag;
        Iterator iter = this.env.tagPrefixes.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (!Pattern.matches("^" + prefix + ".+$", tag) || !prefix.equals("!") && prefix.length() >= tag.length()) continue;
            handle = (String)this.env.tagPrefixes.get(prefix);
            suffix = tag.substring(prefix.length());
        }
        if (handle == null && tag.startsWith("tag:") && tag.indexOf(58, 4) != -1) {
            int doti = tag.indexOf(46, 4);
            String first = tag.substring(4, doti);
            String rest = tag.substring(tag.indexOf(58, 4) + 1);
            handle = "!" + first + "/";
            suffix = rest;
        }
        StringBuffer chunks = new StringBuffer();
        int start = 0;
        for (ending = 0; ending < suffix.length(); ++ending) {
        }
        if (start < ending) {
            chunks.append(suffix.substring(start, ending));
        }
        String suffixText = chunks.toString();
        if (tag.charAt(0) == '!' && this.env.isVersion10) {
            return tag;
        }
        if (handle != null) {
            return handle + suffixText;
        }
        return "!<" + suffixText + ">";
    }

    static ScalarAnalysis analyzeScalar(ByteList scalar) {
        if (scalar == null || scalar.realSize == 0) {
            return new ScalarAnalysis(scalar, true, false, false, true, true, true, false, false);
        }
        boolean blockIndicators = false;
        boolean flowIndicators = false;
        boolean lineBreaks = false;
        boolean specialCharacters = false;
        boolean inlineSpaces = false;
        boolean inlineBreaks = false;
        boolean leadingSpaces = false;
        boolean leadingBreaks = false;
        boolean trailingSpaces = false;
        boolean trailingBreaks = false;
        boolean inlineBreaksSpaces = false;
        boolean mixedBreaksSpaces = false;
        if (DOC_INDIC.matcher(scalar).matches()) {
            blockIndicators = true;
            flowIndicators = true;
        }
        boolean preceededBySpace = true;
        boolean followedBySpace = scalar.length() == 1 || NULL_BL_T_LINEBR.indexOf(scalar.charAt(1)) != -1;
        boolean spaces = false;
        boolean breaks = false;
        boolean mixed = false;
        boolean leading = false;
        int index = 0;
        while (index < scalar.length()) {
            char ceh = scalar.charAt(index);
            if (index == 0) {
                if (SPECIAL_INDIC.indexOf(ceh) != -1) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
                if (ceh == '?' || ceh == ':') {
                    flowIndicators = true;
                    if (followedBySpace) {
                        blockIndicators = true;
                    }
                }
                if (ceh == '-' && followedBySpace) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
            } else {
                if (FLOW_INDIC.indexOf(ceh) != -1) {
                    flowIndicators = true;
                }
                if (ceh == ':') {
                    flowIndicators = true;
                    if (followedBySpace) {
                        blockIndicators = true;
                    }
                }
                if (ceh == '#' && preceededBySpace) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
            }
            if (ceh == '\n') {
                lineBreaks = true;
            }
            if (ceh != '\n' && (' ' > ceh || ceh > '~')) {
                specialCharacters = true;
            }
            if (' ' == ceh || '\n' == ceh) {
                if (spaces && breaks) {
                    if (ceh != ' ') {
                        mixed = true;
                    }
                } else if (spaces) {
                    if (ceh != ' ') {
                        breaks = true;
                        mixed = true;
                    }
                } else if (breaks) {
                    if (ceh == ' ') {
                        spaces = true;
                    }
                } else {
                    boolean bl = leading = index == 0;
                    if (ceh == ' ') {
                        spaces = true;
                    } else {
                        breaks = true;
                    }
                }
            } else if (spaces || breaks) {
                if (leading) {
                    if (spaces && breaks) {
                        mixedBreaksSpaces = true;
                    } else if (spaces) {
                        leadingSpaces = true;
                    } else if (breaks) {
                        leadingBreaks = true;
                    }
                } else if (mixed) {
                    mixedBreaksSpaces = true;
                } else if (spaces && breaks) {
                    inlineBreaksSpaces = true;
                } else if (spaces) {
                    inlineSpaces = true;
                } else if (breaks) {
                    inlineBreaks = true;
                }
                leading = false;
                mixed = false;
                breaks = false;
                spaces = false;
            }
            if ((spaces || breaks) && index == scalar.length() - 1) {
                if (spaces && breaks) {
                    mixedBreaksSpaces = true;
                } else if (spaces) {
                    trailingSpaces = true;
                    if (leading) {
                        leadingSpaces = true;
                    }
                } else if (breaks) {
                    trailingBreaks = true;
                    if (leading) {
                        leadingBreaks = true;
                    }
                }
                leading = false;
                mixed = false;
                breaks = false;
                spaces = false;
            }
            preceededBySpace = NULL_BL_T_LINEBR.indexOf(ceh) != -1;
            followedBySpace = ++index + 1 >= scalar.length() || NULL_BL_T_LINEBR.indexOf(scalar.charAt(index + 1)) != -1;
        }
        boolean allowFlowPlain = true;
        boolean allowBlockPlain = true;
        boolean allowSingleQuoted = true;
        boolean allowDoubleQuoted = true;
        boolean allowBlock = true;
        if (leadingSpaces || leadingBreaks || trailingSpaces) {
            allowSingleQuoted = false;
            allowBlock = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (trailingBreaks) {
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (inlineBreaksSpaces) {
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (mixedBreaksSpaces || specialCharacters) {
            allowBlock = false;
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (inlineBreaks) {
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (trailingBreaks) {
            allowSingleQuoted = false;
        }
        if (lineBreaks) {
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (flowIndicators) {
            allowFlowPlain = false;
        }
        if (blockIndicators) {
            allowBlockPlain = false;
        }
        return new ScalarAnalysis(scalar, false, lineBreaks, allowFlowPlain, allowBlockPlain, allowSingleQuoted, allowDoubleQuoted, allowBlock, specialCharacters);
    }

    static String determineChomp(ByteList text) {
        int ceh = 32;
        int ceh2 = 32;
        if (text.realSize > 0) {
            ceh = (char)(text.bytes[text.realSize - 1] & 0xFF);
            if (text.realSize > 1) {
                ceh2 = (char)(text.bytes[text.realSize - 2] & 0xFF);
            }
        }
        return ceh == 10 ? (ceh2 == 10 ? "+" : "") : "-";
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        System.out.println("File contents:");
        BufferedInputStream read = new BufferedInputStream(new FileInputStream(filename));
        int last = -1;
        while ((last = read.read()) != -1) {
            System.out.print((char)last);
        }
        read.close();
        System.out.println("--------------------------------");
        EmitterImpl emitter = new EmitterImpl(System.out, YAML.config());
        ParserImpl pars = new ParserImpl(new ScannerImpl(new FileInputStream(filename)));
        Iterator iter = pars.eachEvent();
        while (iter.hasNext()) {
            emitter.emit((Event)iter.next());
        }
    }

    static {
        EmitterImpl.STATES[0] = new EmitterState(){

            public void expect(EmitterEnvironment env) {
                env.expectStreamStart();
            }
        };
        EmitterImpl.STATES[1] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectDocumentStart(true);
            }
        };
        EmitterImpl.STATES[2] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectDocumentRoot();
            }
        };
        EmitterImpl.STATES[3] = new EmitterState(){

            public void expect(EmitterEnvironment env) {
                env.expectNothing();
            }
        };
        EmitterImpl.STATES[4] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectDocumentStart(false);
            }
        };
        EmitterImpl.STATES[5] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectDocumentEnd();
            }
        };
        EmitterImpl.STATES[6] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFirstFlowSequenceItem();
            }
        };
        EmitterImpl.STATES[7] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFlowSequenceItem();
            }
        };
        EmitterImpl.STATES[8] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFirstFlowMappingKey();
            }
        };
        EmitterImpl.STATES[9] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFlowMappingSimpleValue();
            }
        };
        EmitterImpl.STATES[10] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFlowMappingValue();
            }
        };
        EmitterImpl.STATES[11] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFlowMappingKey();
            }
        };
        EmitterImpl.STATES[12] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectBlockSequenceItem(false);
            }
        };
        EmitterImpl.STATES[13] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectFirstBlockMappingKey();
            }
        };
        EmitterImpl.STATES[14] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectBlockMappingSimpleValue();
            }
        };
        EmitterImpl.STATES[15] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectBlockMappingValue();
            }
        };
        EmitterImpl.STATES[16] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectBlockMappingKey(false);
            }
        };
        EmitterImpl.STATES[17] = new EmitterState(){

            public void expect(EmitterEnvironment env) throws IOException {
                env.expectBlockSequenceItem(true);
            }
        };
        HashMap<String, String> defInit0 = new HashMap<String, String>();
        defInit0.put("tag:yaml.org,2002:", "!");
        DEFAULT_TAG_PREFIXES_1_0 = Collections.unmodifiableMap(defInit0);
        HashMap<String, String> defInit = new HashMap<String, String>();
        defInit.put("!", "!");
        defInit.put("tag:yaml.org,2002:", "!!");
        DEFAULT_TAG_PREFIXES_1_1 = Collections.unmodifiableMap(defInit);
        HANDLE_FORMAT = Pattern.compile("^![-\\w]*!$");
        ANCHOR_FORMAT = Pattern.compile("^[-\\w]*$");
        DOC_INDIC = Pattern.compile("^(---|\\.\\.\\.)");
        FIRST_SPACE = Pattern.compile("(^|\n) ");
    }

    private static class EmitterEnvironment {
        public List states = new ArrayList();
        public int state = 0;
        public List events = new ArrayList();
        public Event event;
        public int flowLevel = 0;
        public List indents = new ArrayList();
        public int indent = -1;
        public boolean rootContext = false;
        public boolean sequenceContext = false;
        public boolean mappingContext = false;
        public boolean simpleKeyContext = false;
        public int line = 0;
        public int column = 0;
        public boolean whitespace = true;
        public boolean indentation = true;
        public boolean canonical = false;
        public int bestIndent = 2;
        public int bestWidth = 80;
        public ByteList bestLinebreak = ByteList.create("\n");
        public Map tagPrefixes;
        public String preparedAnchor;
        public String preparedTag;
        public ScalarAnalysis analysis;
        public char style = '\u0000';
        public EmitterImpl emitter;
        public boolean isVersion10 = false;

        private EmitterEnvironment() {
        }

        public boolean needMoreEvents() {
            if (this.events.isEmpty()) {
                return true;
            }
            this.event = (Event)this.events.get(0);
            if (this.event instanceof DocumentStartEvent) {
                return this.needEvents(1);
            }
            if (this.event instanceof SequenceStartEvent) {
                return this.needEvents(2);
            }
            if (this.event instanceof MappingStartEvent) {
                return this.needEvents(3);
            }
            return false;
        }

        private boolean needEvents(int count) {
            int level = 0;
            Iterator iter = this.events.iterator();
            iter.next();
            while (iter.hasNext()) {
                Object curr = iter.next();
                if (curr instanceof DocumentStartEvent || curr instanceof CollectionStartEvent) {
                    ++level;
                } else if (curr instanceof DocumentEndEvent || curr instanceof CollectionEndEvent) {
                    --level;
                } else if (curr instanceof StreamEndEvent) {
                    level = -1;
                }
                if (level >= 0) continue;
                return false;
            }
            return this.events.size() < count + 1;
        }

        private void increaseIndent(boolean flow, boolean indentless) {
            this.indents.add(0, new Integer(this.indent));
            if (this.indent == -1) {
                this.indent = flow ? this.bestIndent : 0;
            } else if (!indentless) {
                this.indent += this.bestIndent;
            }
        }

        public void expectStreamStart() {
            if (!(this.event instanceof StreamStartEvent)) {
                throw new EmitterException("expected StreamStartEvent, but got " + this.event);
            }
            this.emitter.writeStreamStart();
            this.state = 1;
        }

        public void expectNothing() {
            throw new EmitterException("expecting nothing, but got " + this.event);
        }

        public void expectDocumentStart(boolean first) throws IOException {
            if (this.event instanceof DocumentStartEvent) {
                boolean implicit;
                DocumentStartEvent ev = (DocumentStartEvent)this.event;
                if (first) {
                    if (null != ev.getVersion()) {
                        this.emitter.writeVersionDirective(EmitterImpl.prepareVersion(ev.getVersion()));
                    }
                    if (null != ev.getVersion() && ev.getVersion()[1] == 0 || this.emitter.getOptions().version().equals("1.0")) {
                        this.isVersion10 = true;
                        this.tagPrefixes = new HashMap(DEFAULT_TAG_PREFIXES_1_0);
                    } else {
                        this.tagPrefixes = new HashMap(DEFAULT_TAG_PREFIXES_1_1);
                    }
                    if (null != ev.getTags()) {
                        TreeSet handles = new TreeSet();
                        handles.addAll(ev.getTags().keySet());
                        Iterator iter = handles.iterator();
                        while (iter.hasNext()) {
                            String handle = (String)iter.next();
                            String prefix = (String)ev.getTags().get(handle);
                            this.tagPrefixes.put(prefix, handle);
                            String handleText = EmitterImpl.prepareTagHandle(handle);
                            String prefixText = EmitterImpl.prepareTagPrefix(prefix);
                            this.emitter.writeTagDirective(handleText, prefixText);
                        }
                    }
                }
                boolean bl = implicit = first && !ev.getExplicit() && !this.canonical && ev.getVersion() == null && ev.getTags() == null && !this.checkEmptyDocument();
                if (!implicit) {
                    this.emitter.writeIndent();
                    this.emitter.writeIndicator(ByteList.create("--- "), true, true, false);
                    if (this.canonical) {
                        this.emitter.writeIndent();
                    }
                }
                this.state = 2;
            } else if (this.event instanceof StreamEndEvent) {
                this.emitter.writeStreamEnd();
                this.state = 3;
            } else {
                throw new EmitterException("expected DocumentStartEvent, but got " + this.event);
            }
        }

        public void expectDocumentRoot() throws IOException {
            this.states.add(0, new Integer(5));
            this.expectNode(true, false, false, false);
        }

        public void expectDocumentEnd() throws IOException {
            if (this.event instanceof DocumentEndEvent) {
                this.emitter.writeIndent();
                if (((DocumentEndEvent)this.event).getExplicit()) {
                    this.emitter.writeIndicator(ByteList.create("..."), true, false, false);
                    this.emitter.writeIndent();
                }
            } else {
                throw new EmitterException("expected DocumentEndEvent, but got " + this.event);
            }
            this.emitter.flushStream();
            this.state = 4;
        }

        public void expectFirstFlowSequenceItem() throws IOException {
            if (this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                this.emitter.writeIndicator(ByteList.create("]"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                this.states.add(0, new Integer(7));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFlowSequenceItem() throws IOException {
            if (this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                if (this.canonical) {
                    this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                    this.emitter.writeIndent();
                }
                this.emitter.writeIndicator(ByteList.create("]"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                this.states.add(0, new Integer(7));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFirstFlowMappingKey() throws IOException {
            if (this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                this.emitter.writeIndicator(ByteList.create("}"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                if (!this.canonical && this.checkSimpleKey()) {
                    this.states.add(0, new Integer(9));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, false);
                    this.states.add(0, new Integer(10));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        public void expectFlowMappingSimpleValue() throws IOException {
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(11));
            this.expectNode(false, false, true, false);
        }

        public void expectFlowMappingValue() throws IOException {
            if (this.canonical || this.column > this.bestWidth) {
                this.emitter.writeIndent();
            }
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(11));
            this.expectNode(false, false, true, false);
        }

        public void expectFlowMappingKey() throws IOException {
            if (this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                --this.flowLevel;
                if (this.canonical) {
                    this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                    this.emitter.writeIndent();
                }
                this.emitter.writeIndicator(ByteList.create("}"), false, false, false);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndicator(ByteList.create(","), false, false, false);
                if (this.canonical || this.column > this.bestWidth) {
                    this.emitter.writeIndent();
                }
                if (!this.canonical && this.checkSimpleKey()) {
                    this.states.add(0, new Integer(9));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, false);
                    this.states.add(0, new Integer(10));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        public void expectBlockSequenceItem(boolean first) throws IOException {
            if (!first && this.event instanceof SequenceEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndent();
                this.emitter.writeIndicator(ByteList.create("-"), true, false, true);
                this.states.add(0, new Integer(12));
                this.expectNode(false, true, false, false);
            }
        }

        public void expectFirstBlockMappingKey() throws IOException {
            this.expectBlockMappingKey(true);
        }

        public void expectBlockMappingSimpleValue() throws IOException {
            this.emitter.writeIndicator(ByteList.create(": "), false, true, false);
            this.states.add(0, new Integer(16));
            this.expectNode(false, false, true, false);
        }

        public void expectBlockMappingValue() throws IOException {
            this.emitter.writeIndent();
            this.emitter.writeIndicator(ByteList.create(": "), true, true, true);
            this.states.add(0, new Integer(16));
            this.expectNode(false, false, true, false);
        }

        public void expectBlockMappingKey(boolean first) throws IOException {
            if (!first && this.event instanceof MappingEndEvent) {
                this.indent = (Integer)this.indents.remove(0);
                this.state = (Integer)this.states.remove(0);
            } else {
                this.emitter.writeIndent();
                if (this.checkSimpleKey()) {
                    this.states.add(0, new Integer(14));
                    this.expectNode(false, false, true, true);
                } else {
                    this.emitter.writeIndicator(ByteList.create("?"), true, false, true);
                    this.states.add(0, new Integer(15));
                    this.expectNode(false, false, true, false);
                }
            }
        }

        private void expectNode(boolean root, boolean sequence, boolean mapping, boolean simpleKey) throws IOException {
            this.rootContext = root;
            this.sequenceContext = sequence;
            this.mappingContext = mapping;
            this.simpleKeyContext = simpleKey;
            if (this.event instanceof AliasEvent) {
                this.expectAlias();
            } else if (this.event instanceof ScalarEvent || this.event instanceof CollectionStartEvent) {
                this.processAnchor(ByteList.create("&"));
                this.processTag();
                if (this.event instanceof ScalarEvent) {
                    this.expectScalar();
                } else if (this.event instanceof SequenceStartEvent) {
                    if (this.flowLevel != 0 || this.canonical || ((SequenceStartEvent)this.event).getFlowStyle() || this.checkEmptySequence()) {
                        this.expectFlowSequence();
                    } else {
                        this.expectBlockSequence();
                    }
                } else if (this.event instanceof MappingStartEvent) {
                    if (this.flowLevel != 0 || this.canonical || ((MappingStartEvent)this.event).getFlowStyle() || this.checkEmptyMapping()) {
                        this.expectFlowMapping();
                    } else {
                        this.expectBlockMapping();
                    }
                }
            } else {
                throw new EmitterException("expected NodeEvent, but got " + this.event);
            }
        }

        private void expectAlias() throws IOException {
            if (((NodeEvent)this.event).getAnchor() == null) {
                throw new EmitterException("anchor is not specified for alias");
            }
            this.processAnchor(ByteList.create("*"));
            this.state = (Integer)this.states.remove(0);
        }

        private void expectScalar() throws IOException {
            this.increaseIndent(true, false);
            this.processScalar();
            this.indent = (Integer)this.indents.remove(0);
            this.state = (Integer)this.states.remove(0);
        }

        private void expectFlowSequence() throws IOException {
            this.emitter.writeIndicator(ByteList.create("["), true, true, false);
            ++this.flowLevel;
            this.increaseIndent(true, false);
            this.state = 6;
        }

        private void expectBlockSequence() throws IOException {
            this.increaseIndent(false, this.mappingContext && !this.indentation);
            this.state = 17;
        }

        private void expectFlowMapping() throws IOException {
            this.emitter.writeIndicator(ByteList.create("{"), true, true, false);
            ++this.flowLevel;
            this.increaseIndent(true, false);
            this.state = 8;
        }

        private void expectBlockMapping() throws IOException {
            this.increaseIndent(false, false);
            this.state = 13;
        }

        private boolean checkEmptySequence() {
            return this.event instanceof SequenceStartEvent && !this.events.isEmpty() && this.events.get(0) instanceof SequenceEndEvent;
        }

        private boolean checkEmptyMapping() {
            return this.event instanceof MappingStartEvent && !this.events.isEmpty() && this.events.get(0) instanceof MappingEndEvent;
        }

        private boolean checkEmptyDocument() {
            if (!(this.event instanceof DocumentStartEvent) || this.events.isEmpty()) {
                return false;
            }
            Event ev = (Event)this.events.get(0);
            return ev instanceof ScalarEvent && ((ScalarEvent)ev).getAnchor() == null && ((ScalarEvent)ev).getTag() == null && ((ScalarEvent)ev).getImplicit() != null && ((ScalarEvent)ev).getValue().realSize == 0;
        }

        private boolean checkSimpleKey() {
            int length = 0;
            if (this.event instanceof NodeEvent && null != ((NodeEvent)this.event).getAnchor()) {
                if (null == this.preparedAnchor) {
                    this.preparedAnchor = EmitterImpl.prepareAnchor(((NodeEvent)this.event).getAnchor());
                }
                length += this.preparedAnchor.length();
            }
            String tag = null;
            if (this.event instanceof ScalarEvent) {
                tag = ((ScalarEvent)this.event).getTag();
            } else if (this.event instanceof CollectionStartEvent) {
                tag = ((CollectionStartEvent)this.event).getTag();
            }
            if (tag != null) {
                if (null == this.preparedTag) {
                    this.preparedTag = this.emitter.prepareTag(tag);
                }
                length += this.preparedTag.length();
            }
            if (this.event instanceof ScalarEvent && null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(((ScalarEvent)this.event).getValue());
                length += this.analysis.scalar.length();
            }
            return length < 128 && (this.event instanceof AliasEvent || this.event instanceof ScalarEvent && !this.analysis.multiline || this.checkEmptySequence() || this.checkEmptyMapping());
        }

        private void processAnchor(ByteList indicator) throws IOException {
            NodeEvent ev = (NodeEvent)this.event;
            if (null == ev.getAnchor()) {
                this.preparedAnchor = null;
                return;
            }
            if (null == this.preparedAnchor) {
                this.preparedAnchor = EmitterImpl.prepareAnchor(ev.getAnchor());
            }
            if (this.preparedAnchor != null && !"".equals(this.preparedAnchor)) {
                indicator.append(this.preparedAnchor.getBytes());
                if (ev instanceof CollectionStartEvent) {
                    this.indentation = true;
                }
                this.emitter.writeIndicator(indicator, true, false, true);
            }
            this.preparedAnchor = null;
        }

        private void processTag() throws IOException {
            String tag = null;
            if (this.event instanceof ScalarEvent) {
                ScalarEvent ev = (ScalarEvent)this.event;
                tag = ev.getTag();
                if (this.style == '\u0000') {
                    this.style = this.chooseScalarStyle();
                }
                if ((!this.canonical || tag == null) && ('\u0000' == this.style && ev.getImplicit()[0] || '\u0000' != this.style && ev.getImplicit()[1])) {
                    this.preparedTag = null;
                    return;
                }
                if (ev.getImplicit()[0] && null == tag) {
                    tag = "!";
                    this.preparedTag = null;
                }
            } else {
                CollectionStartEvent ev = (CollectionStartEvent)this.event;
                tag = ev.getTag();
                if ((!this.canonical || tag == null) && ev.getImplicit()) {
                    this.preparedTag = null;
                    return;
                }
                this.indentation = true;
            }
            if (tag == null) {
                throw new EmitterException("tag is not specified");
            }
            if (null == this.preparedTag) {
                this.preparedTag = this.emitter.prepareTag(tag);
            }
            if (this.preparedTag != null && !"".equals(this.preparedTag)) {
                this.emitter.writeIndicator(ByteList.create(this.preparedTag), true, false, true);
            }
            this.preparedTag = null;
        }

        private char chooseScalarStyle() {
            ScalarEvent ev = (ScalarEvent)this.event;
            if (null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(ev.getValue());
            }
            if (ev.getStyle() == '\"' || this.canonical || this.analysis.empty && ev.getTag().equals("tag:yaml.org,2002:str")) {
                return '\"';
            }
            if (ev.getStyle() == '\u0000' && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
                return '\u0000';
            }
            if (ev.getStyle() == '\u0000' && ev.getImplicit()[0] && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
                return '\u0000';
            }
            if ((ev.getStyle() == '|' || ev.getStyle() == '>') && this.flowLevel == 0 && this.analysis.allowBlock) {
                return '\'';
            }
            if (!(ev.getStyle() != '\u0000' && ev.getStyle() != '\'' || !this.analysis.allowSingleQuoted || this.simpleKeyContext && this.analysis.multiline)) {
                return '\'';
            }
            if (this.analysis.multiline && !FIRST_SPACE.matcher(ev.getValue()).find() && !this.analysis.specialCharacters) {
                return '|';
            }
            return '\"';
        }

        private void processScalar() throws IOException {
            boolean split;
            ScalarEvent ev = (ScalarEvent)this.event;
            if (null == this.analysis) {
                this.analysis = EmitterImpl.analyzeScalar(ev.getValue());
            }
            if ('\u0000' == this.style) {
                this.style = this.chooseScalarStyle();
            }
            boolean bl = split = !this.simpleKeyContext;
            if (this.style == '\"') {
                this.emitter.writeDoubleQuoted(this.analysis.scalar, split);
            } else if (this.style == '\'') {
                this.emitter.writeSingleQuoted(this.analysis.scalar, split);
            } else if (this.style == '>') {
                this.emitter.writeFolded(this.analysis.scalar);
            } else if (this.style == '|') {
                this.emitter.writeLiteral(this.analysis.scalar);
            } else {
                this.emitter.writePlain(this.analysis.scalar, split);
            }
            this.analysis = null;
            this.style = '\u0000';
        }
    }

    private static interface EmitterState {
        public void expect(EmitterEnvironment var1) throws IOException;
    }

    private static class ScalarAnalysis {
        public ByteList scalar;
        public boolean empty;
        public boolean multiline;
        public boolean allowFlowPlain;
        public boolean allowBlockPlain;
        public boolean allowSingleQuoted;
        public boolean allowDoubleQuoted;
        public boolean allowBlock;
        public boolean specialCharacters;

        public ScalarAnalysis(ByteList scalar, boolean empty, boolean multiline, boolean allowFlowPlain, boolean allowBlockPlain, boolean allowSingleQuoted, boolean allowDoubleQuoted, boolean allowBlock, boolean specialCharacters) {
            this.scalar = scalar;
            this.empty = empty;
            this.multiline = multiline;
            this.allowFlowPlain = allowFlowPlain;
            this.allowBlockPlain = allowBlockPlain;
            this.allowSingleQuoted = allowSingleQuoted;
            this.allowDoubleQuoted = allowDoubleQuoted;
            this.allowBlock = allowBlock;
            this.specialCharacters = specialCharacters;
        }
    }
}

