/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;

public class MethodCache {
    private static final Reference NULL_REFERENCE = new WeakReference<Object>(null);
    private static int CACHE_SIZE = 2048;
    private static int CACHE_MASK = 2047;
    private boolean initialized = false;
    private CacheEntry[] cache = new CacheEntry[CACHE_SIZE];

    public MethodCache() {
        this.clearAllEntries();
    }

    public void initialized() {
        this.initialized = true;
    }

    public void clearCache() {
        if (!this.initialized) {
            return;
        }
        this.clearAllEntries();
    }

    private void clearAllEntries() {
        for (int i = 0; i < CACHE_SIZE; ++i) {
            this.cache[i] = new CacheEntry();
            this.cache[i].klass = NULL_REFERENCE;
            this.cache[i].mid = null;
            this.cache[i].method = NULL_REFERENCE;
        }
    }

    private int cacheIndex(RubyModule c, String id) {
        return (c.hashCode() >> 3 ^ id.hashCode()) & CACHE_MASK;
    }

    public CacheEntry getMethod(RubyModule c, String id) {
        int index = this.cacheIndex(c, id);
        return this.cache[index];
    }

    public void putMethod(RubyModule c, String id, DynamicMethod m) {
        int index = this.cacheIndex(c, id);
        this.cache[index].klass = new WeakReference<RubyModule>(c);
        this.cache[index].mid = id;
        this.cache[index].method = new WeakReference<DynamicMethod>(m);
    }

    public void removeMethod(RubyClass c, String id) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (!id.equals(entry.mid) || entry.klass.get() != c) continue;
            entry.mid = null;
        }
    }

    public void removeMethod(String id) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (!id.equals(entry.mid)) continue;
            entry.mid = null;
        }
    }

    public void removeClass(RubyClass c) {
        if (!this.initialized) {
            return;
        }
        for (int i = 0; i < CACHE_SIZE; ++i) {
            CacheEntry entry = this.cache[i];
            if (entry.klass.get() != c) continue;
            entry.mid = null;
        }
    }

    static /* synthetic */ Reference access$000() {
        return NULL_REFERENCE;
    }

    public static class CacheEntry {
        public Reference klass = MethodCache.access$000();
        public String mid;
        public Reference method = MethodCache.access$000();
    }
}

