/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby runtime) {
        RubyModule javaArrayUtils = runtime.defineModule("JavaArrayUtilities");
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaArrayUtilities.class);
        javaArrayUtils.defineFastModuleFunction("bytes_to_ruby_string", callbackFactory.getFastSingletonMethod("bytes_to_ruby_string", IRubyObject.class));
        javaArrayUtils.defineFastModuleFunction("ruby_string_to_bytes", callbackFactory.getFastSingletonMethod("ruby_string_to_bytes", IRubyObject.class));
        return javaArrayUtils;
    }

    public static IRubyObject bytes_to_ruby_string(IRubyObject recv, IRubyObject wrappedObject) {
        Ruby runtime = recv.getRuntime();
        IRubyObject byteArray = wrappedObject.getInstanceVariable("@java_object");
        if (!(byteArray instanceof JavaArray) || !(((JavaArray)byteArray).getValue() instanceof byte[])) {
            throw runtime.newTypeError("wrong argument type " + wrappedObject.getMetaClass() + " (expected byte[])");
        }
        return runtime.newString(new ByteList((byte[])((JavaArray)byteArray).getValue(), true));
    }

    public static IRubyObject ruby_string_to_bytes(IRubyObject recv, IRubyObject string) {
        Ruby runtime = recv.getRuntime();
        if (!(string instanceof RubyString)) {
            throw runtime.newTypeError(string, runtime.getString());
        }
        return Java.java_to_ruby(recv, JavaObject.wrap(runtime, ((RubyString)string).getBytes()), Block.NULL_BLOCK);
    }
}

