/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jbpm.AbstractWorkflowOperation;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.jbpm.dashboard.DocumentProcessItem;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Workflow.UserProcessPageProvider", category="Services", label="UserProcessPageProvider", description="Returns the current user's processes.")
public class UserProcessPageProviderOperation
extends AbstractWorkflowOperation {
    public static final String ID = "Workflow.UserProcessPageProvider";
    public static final String USER_PROCESSES_PAGE_PROVIDER = "user_processes";
    @Param(name="language", required=false)
    protected String language;
    @Param(name="page", required=false)
    protected Integer page;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Context
    protected CoreSession session;
    @Context
    protected DocumentViewCodecManager documentViewCodecManager;

    @OperationMethod
    public Blob run() throws Exception {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        PageProvider pageProvider = pps.getPageProvider(USER_PROCESSES_PAGE_PROVIDER, null, targetPageSize, targetPage, props, new Object[0]);
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        JSONArray processes = new JSONArray();
        for (DocumentProcessItem process : pageProvider.getCurrentPage()) {
            JSONObject obj = new JSONObject();
            obj.put((Object)"processInstanceName", (Object)this.getI18nProcessInstanceName(process.getProcessInstanceName(), locale));
            obj.put((Object)"documentTitle", (Object)process.getDocumentModel().getTitle());
            obj.put((Object)"documentLink", (Object)this.getDocumentLink(this.documentViewCodecManager, process.getDocumentModel(), true));
            Date startDate = process.getProcessInstanceStartDate();
            obj.put((Object)"startDate", (Object)(startDate != null ? DateParser.formatW3CDateTime((Date)startDate) : ""));
            process.getProcessInstanceName();
            processes.add((Object)obj);
        }
        JSONObject json = new JSONObject();
        json.put((Object)"isPaginable", (Object)Boolean.TRUE);
        json.put((Object)"totalSize", (Object)pageProvider.getResultsCount());
        json.put((Object)"pageIndex", (Object)pageProvider.getCurrentPageIndex());
        json.put((Object)"pageSize", (Object)pageProvider.getPageSize());
        json.put((Object)"pageCount", (Object)pageProvider.getNumberOfPages());
        json.put((Object)"entries", (Object)processes);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.toString().getBytes("UTF-8")), "application/json");
    }

    protected String getI18nProcessInstanceName(String processInstanceName, Locale locale) {
        String labelKey = "document_" + processInstanceName;
        return this.getI18nLabel(labelKey, locale);
    }
}

