/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jbpm;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.Comment;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.jbpm.JbpmListFilter;
import org.nuxeo.ecm.platform.jbpm.JbpmService;

@Operation(id="Workflow.GetJBPMTask", category="Services", label="Get user tasks", since="5.4", description="List tasks assigned to this user or one of its group.Task properties are serialized using JSON and returned in a Blob.")
public class GetUserTasks {
    public static final String ID = "Workflow.GetJBPMTask";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession repo;
    @Context
    protected JbpmService srv;

    @OperationMethod
    public Blob run() throws Exception {
        NuxeoPrincipal principal = this.principal();
        List tasks = this.srv.getCurrentTaskInstances(principal, this.filter());
        if (tasks == null) {
            return null;
        }
        JSONArray rows = new JSONArray();
        for (TaskInstance task : tasks) {
            DocumentModel doc = null;
            try {
                doc = this.srv.getDocumentModel(task, principal);
            }
            catch (Exception e) {
                log.warn((Object)("Cannot get doc for task " + task.getId()), (Throwable)e);
            }
            if (doc == null) {
                log.warn((Object)String.format("User '%s' has a task of type '%s' on an unexisting or invisible document", principal.getName(), task.getName()));
                continue;
            }
            JSONObject obj = new JSONObject();
            obj.element("id", task.getId());
            obj.element("docref", (Object)doc.getRef().toString());
            obj.element("name", (Object)task.getName());
            obj.element("description", (Object)task.getDescription());
            obj.element("startDate", (Object)task.getCreate());
            boolean expired = false;
            Date dueDate = task.getDueDate();
            obj.element("dueDate", (Object)task.getDueDate());
            if (dueDate != null) {
                expired = dueDate.before(new Date());
            }
            obj.element("expired", expired);
            obj.element("directive", task.getVariableLocally(JbpmService.TaskVariableName.directive.name()));
            List comments = task.getComments();
            String comment = "";
            if (comments != null && !comments.isEmpty()) {
                comment = ((Comment)comments.get(comments.size() - 1)).getMessage();
            }
            obj.element("comment", (Object)comment);
            rows.add((Object)obj);
        }
        return new StringBlob(rows.toString(), "application/json");
    }

    protected NuxeoPrincipal principal() {
        return (NuxeoPrincipal)this.ctx.getPrincipal();
    }

    protected JbpmListFilter filter() {
        return new JbpmListFilter(){
            private static final long serialVersionUID = 1L;

            public <T> ArrayList<T> filter(JbpmContext jbpmContext, DocumentModel document, ArrayList<T> list, NuxeoPrincipal principal) {
                return list;
            }
        };
    }
}

