/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.repository;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XML {
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private static final OutputFormat DEFAULT_FORMAT = new OutputFormat();

    private XML() {
    }

    public static DocumentBuilderFactory getBuilderFactory() {
        return builderFactory;
    }

    public static String toString(Element element) throws IOException {
        return XML.toString(element, DEFAULT_FORMAT);
    }

    public static String toString(Element element, OutputFormat format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XML.write(element, format, (OutputStream)baos);
        return baos.toString();
    }

    public static String toString(Document doc) throws IOException {
        return XML.toString(doc, DEFAULT_FORMAT);
    }

    public static String toString(Document doc, OutputFormat format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XML.write(doc, format, (OutputStream)baos);
        return baos.toString();
    }

    public static void write(Element element, OutputStream out) throws IOException {
        XML.write(element, DEFAULT_FORMAT, out);
    }

    public static void write(Element element, OutputFormat format, OutputStream out) throws IOException {
        XMLSerializer serializer = new XMLSerializer(out, format);
        serializer.asDOMSerializer().serialize(element);
    }

    public static void write(Document doc, OutputStream out) throws IOException {
        XML.write(doc, DEFAULT_FORMAT, out);
    }

    public static void write(Document doc, OutputFormat format, OutputStream out) throws IOException {
        XMLSerializer serializer = new XMLSerializer(out, format);
        serializer.asDOMSerializer().serialize(doc);
    }

    static {
        DEFAULT_FORMAT.setOmitXMLDeclaration(false);
        DEFAULT_FORMAT.setIndenting(true);
        DEFAULT_FORMAT.setMethod("xml");
        DEFAULT_FORMAT.setEncoding("UTF-8");
    }
}

