/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.extensions;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.LifeCycleTransition;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleStateConfiguration;
import org.nuxeo.ecm.core.lifecycle.extensions.LifeCycleTransitionConfiguration;
import org.nuxeo.ecm.core.lifecycle.impl.LifeCycleImpl;
import org.w3c.dom.Element;

@XObject(value="lifecycle", order={"@name"})
public class LifeCycleDescriptor {
    private static final Log log = LogFactory.getLog(LifeCycleDescriptor.class);
    @XNode(value="@name")
    private String name;
    @XNode(value="@initial")
    private String initialStateName;
    @XNode(value="@defaultInitial")
    private String defaultInitialStateName;
    @XNode(value="description")
    private String description;
    @XNode(value="states")
    private Element states;
    @XNode(value="transitions")
    private Element transitions;

    @XNode(value="@lifecyclemanager")
    public void setLifeCycleManager(String lifeCycleManager) {
        log.warn((Object)("Ignoring deprecated lifecyclemanager attribute '" + lifeCycleManager + "' for lifecycle '" + this.name + "'"));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getInitialStateName() {
        return this.initialStateName;
    }

    public String getDefaultInitialStateName() {
        return this.defaultInitialStateName;
    }

    public Collection<LifeCycleState> getStates() {
        LifeCycleStateConfiguration conf = new LifeCycleStateConfiguration(this.states);
        return conf.getStates();
    }

    public Collection<LifeCycleTransition> getTransitions() {
        return new LifeCycleTransitionConfiguration(this.transitions).getTransitions();
    }

    public LifeCycle getLifeCycle() {
        String defaultInitialStateName = this.defaultInitialStateName;
        if (this.initialStateName != null) {
            defaultInitialStateName = this.initialStateName;
            log.warn((Object)String.format("Lifecycle registration of default initial state has changed, change initial=\"%s\" to defaultInitial=\"%s\" in lifecyle '%s' definition", defaultInitialStateName, defaultInitialStateName, this.name));
        }
        boolean defaultInitialStateFound = false;
        HashSet<String> initialStateNames = new HashSet<String>();
        Collection<LifeCycleState> states = this.getStates();
        for (LifeCycleState state : states) {
            String stateName = state.getName();
            if (defaultInitialStateName.equals(stateName)) {
                defaultInitialStateFound = true;
                initialStateNames.add(stateName);
            }
            if (!state.isInitial()) continue;
            initialStateNames.add(stateName);
        }
        if (!defaultInitialStateFound) {
            log.error((Object)String.format("Default initial state %s not found on lifecycle %s", defaultInitialStateName, this.name));
        }
        return new LifeCycleImpl(this.name, defaultInitialStateName, initialStateNames, states, this.getTransitions());
    }
}

