/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.TransactionalCoreSessionWrapper;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.LoginComponent;

public class LocalSession
extends AbstractSession {
    private static final long serialVersionUID = 1L;
    private Session session;
    private Boolean supportsTags;

    public static CoreSession createInstance() {
        LocalSession session = new LocalSession();
        return TransactionalCoreSessionWrapper.wrap(session);
    }

    protected Session createSession(String repoName) throws ClientException {
        try {
            LoginStack.Entry entry;
            Object principal = null;
            if (this.sessionContext != null) {
                String username;
                principal = (NuxeoPrincipal)this.sessionContext.get("principal");
                if (principal == null && (username = (String)this.sessionContext.get("username")) != null) {
                    principal = "system".equals(username) ? new SystemPrincipal(null) : new UserPrincipal(username, new ArrayList(), false, false);
                }
            } else {
                this.sessionContext = new HashMap();
            }
            if (principal == null && (entry = ClientLoginModule.getCurrentLogin()) != null) {
                Principal p = entry.getPrincipal();
                if (p instanceof NuxeoPrincipal) {
                    principal = (NuxeoPrincipal)p;
                } else if (LoginComponent.isSystemLogin((Object)p)) {
                    principal = new SystemPrincipal(p.getName());
                } else {
                    throw new Error("Unsupported principal: " + p.getClass());
                }
            }
            if (principal == null) {
                if (this.isTestingContext()) {
                    principal = new SystemPrincipal(null);
                } else {
                    throw new ClientException("Cannot create a core session outside a security context. You must login first.");
                }
            }
            this.sessionContext.put("principal", principal);
            Repository repo = this.lookupRepository(repoName);
            this.supportsTags = repo.supportsTags();
            return repo.getSession(this.sessionContext);
        }
        catch (Exception e) {
            throw new ClientException("Failed to load repository " + repoName, (Throwable)e);
        }
    }

    public boolean supportsTags(String repositoryName) throws ClientException {
        try {
            Repository repo = this.lookupRepository(repositoryName);
            return repo.supportsTags();
        }
        catch (Exception e) {
            throw new ClientException("Failed to load repository " + repositoryName, (Throwable)e);
        }
    }

    public boolean supportsTags() throws ClientException {
        if (this.supportsTags != null) {
            return this.supportsTags;
        }
        throw new ClientException("Can not query on a closed repository");
    }

    protected Repository lookupRepository(String name) throws Exception {
        Repository repo;
        try {
            repo = (Repository)new InitialContext().lookup("NXRepository/" + name);
        }
        catch (NamingException e) {
            try {
                repo = (Repository)new InitialContext().lookup("java:NXRepository/" + name);
            }
            catch (NamingException ee) {
                repo = NXCore.getRepositoryService().getRepositoryManager().getRepository(name);
            }
        }
        if (repo == null) {
            throw new IllegalArgumentException("Repository not found: " + name);
        }
        return repo;
    }

    public boolean isTestingContext() {
        return Framework.isTestModeSet();
    }

    @Override
    public Principal getPrincipal() {
        return (Principal)this.sessionContext.get("principal");
    }

    @Override
    public Session getSession() throws ClientException {
        if (this.session == null || !this.session.isLive()) {
            this.session = this.createSession(this.repositoryName);
        }
        return this.session;
    }

    @Override
    public void cancel() throws ClientException {
        if (this.session != null && this.session.isLive()) {
            super.cancel();
        }
    }

    public boolean isStateSharedByAllThreadSessions() {
        return false;
    }

    @Override
    public boolean isSessionAlive() {
        return this.session != null && this.session.isLive();
    }
}

