/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.platform.audit.api.AuditException;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.runtime.api.Framework;

public class AuditEventLogger
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(AuditEventLogger.class);

    protected AuditLogger getAuditLogger() throws ClientException {
        try {
            return (AuditLogger)Framework.getService(AuditLogger.class);
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
    }

    public void handleEvent(EventBundle events) throws ClientException {
        AuditLogger logger = this.getAuditLogger();
        if (logger != null) {
            try {
                logger.logEvents(events);
            }
            catch (AuditException e) {
                log.error((Object)"Unable to persist event bundle into audit log", (Throwable)e);
            }
        } else {
            log.error((Object)"Can not reach AuditLogger");
        }
    }
}

