/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Collection;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendering.api.DefaultDocumentView;

public class DocumentTemplate
implements TemplateHashModelEx,
AdapterTemplateModel {
    protected final ObjectWrapper wrapper;
    protected final DocumentModel doc;

    public DocumentTemplate(ObjectWrapper wrapper, DocumentModel doc) {
        this.doc = doc;
        this.wrapper = wrapper;
    }

    public Object getAdaptedObject(Class hint) {
        return this.doc;
    }

    public DocumentModel getDocument() {
        return this.doc;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        try {
            Object value = DefaultDocumentView.DEFAULT.get(this.doc, key);
            if (value != DefaultDocumentView.UNKNOWN) {
                return this.wrapper.wrap(value);
            }
        }
        catch (Exception e) {
            throw new TemplateModelException("Failed to get document field: " + key, e);
        }
        return null;
    }

    public CoreSession getSession() {
        return CoreInstance.getInstance().getSession(this.doc.getSessionId());
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    public Collection<String> getRawKeys() {
        return DefaultDocumentView.DEFAULT.getFields().keySet();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.wrap(this.getRawKeys());
    }

    public Collection<Object> getRawValues() throws TemplateModelException {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            Collection<DefaultDocumentView.Field> fields = DefaultDocumentView.DEFAULT.getFields().values();
            for (DefaultDocumentView.Field field : fields) {
                values.add(field.getValue(this.doc));
            }
        }
        catch (Exception e) {
            throw new TemplateModelException("failed to fetch field values", e);
        }
        return values;
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.wrap(this.getRawValues());
    }

    public int size() throws TemplateModelException {
        return DefaultDocumentView.DEFAULT.size(null);
    }
}

