/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.api.test;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.util.SimpleRuntime;

public abstract class NXClientTestCase
extends TestCase {
    protected static RuntimeService runtime;
    private static final Log log;

    protected void setUp() throws Exception {
        super.setUp();
        this.initializeRT();
    }

    protected void tearDown() throws Exception {
        NXClientTestCase.shutdownRT();
        super.tearDown();
    }

    protected File getHomeDir() {
        return null;
    }

    private void initializeRT() throws Exception {
        File home = this.getHomeDir();
        runtime = new SimpleRuntime(home);
        Framework.initialize((RuntimeService)runtime);
        this.deployAll();
    }

    private static void shutdownRT() throws Exception {
        Framework.shutdown();
    }

    protected void deploy(String bundle) {
        URL url = this.getResource(bundle);
        if (null == url) {
            log.error((Object)("cannot deploy bundle: " + bundle + ". not found"));
            Thread.dumpStack();
            return;
        }
        try {
            Framework.getRuntime().getContext().deploy(url);
        }
        catch (Exception e) {
            log.error((Object)("cannot deploy bundle: " + bundle), (Throwable)e);
        }
    }

    protected void undeploy(String bundle) {
        URL url = this.getResource(bundle);
        assert (url != null);
        try {
            Framework.getRuntime().getContext().undeploy(url);
        }
        catch (Exception e) {
            log.error((Object)("cannot undeploy bundle: " + bundle), (Throwable)e);
        }
    }

    protected URL getResource(String resource) {
        return runtime.getContext().getResource(resource);
    }

    protected void deployAll() {
        this.deploy("EventService.xml");
    }

    static {
        log = LogFactory.getLog(NXClientTestCase.class);
    }
}

