/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import org.apache.pdfbox.io.RandomAccess;

public class RandomAccessBuffer
implements RandomAccess {
    private byte[] buffer = new byte[16384];
    private long pointer = 0L;
    private long size = 0L;

    public void close() throws IOException {
        this.buffer = null;
        this.pointer = 0L;
        this.size = 0L;
    }

    public void seek(long position) throws IOException {
        this.pointer = position;
    }

    public int read() throws IOException {
        if (this.pointer >= this.size) {
            return -1;
        }
        return this.buffer[(int)this.pointer++] & 0xFF;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (this.pointer >= this.size) {
            return 0;
        }
        int maxLength = (int)Math.min((long)length, this.size - this.pointer);
        System.arraycopy(this.buffer, (int)this.pointer, b, offset, maxLength);
        this.pointer += (long)maxLength;
        return maxLength;
    }

    public long length() throws IOException {
        return this.size;
    }

    public void write(int b) throws IOException {
        if (this.pointer >= (long)this.buffer.length) {
            if (this.pointer >= Integer.MAX_VALUE) {
                throw new IOException("RandomAccessBuffer overflow");
            }
            this.buffer = this.expandBuffer(this.buffer, (int)Math.min(2L * (long)this.buffer.length, Integer.MAX_VALUE));
        }
        this.buffer[(int)this.pointer++] = (byte)b;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        long newSize = this.pointer + (long)length;
        if (newSize >= (long)this.buffer.length) {
            if (newSize > Integer.MAX_VALUE) {
                throw new IOException("RandomAccessBuffer overflow");
            }
            newSize = Math.min(Math.max(2L * (long)this.buffer.length, newSize), Integer.MAX_VALUE);
            this.buffer = this.expandBuffer(this.buffer, (int)newSize);
        }
        System.arraycopy(b, offset, this.buffer, (int)this.pointer, length);
        this.pointer += (long)length;
        if (this.pointer > this.size) {
            this.size = this.pointer;
        }
    }

    private byte[] expandBuffer(byte[] buffer, int newSize) {
        byte[] expandedBuffer = new byte[newSize];
        System.arraycopy(buffer, 0, expandedBuffer, 0, buffer.length);
        return expandedBuffer;
    }
}

