/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work;

import java.util.concurrent.CountDownLatch;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkAdapter;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.apache.geronimo.transaction.manager.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.manager.XAWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerContext
implements Work {
    private static final Logger log = LoggerFactory.getLogger(WorkerContext.class);
    private static final WorkListener NULL_WORK_LISTENER = new WorkAdapter(){

        public void workRejected(WorkEvent event) {
            if (event.getException() != null) {
                if (event.getException() instanceof WorkCompletedException && event.getException().getCause() != null) {
                    log.error(event.getWork().toString(), event.getException().getCause());
                } else {
                    log.error(event.getWork().toString(), (Throwable)event.getException());
                }
            }
        }
    };
    private int threadPriority;
    private Work adaptee;
    private boolean isAccepted;
    private long acceptedTime;
    private int nbRetry;
    private long startTimeOut;
    private final ExecutionContext executionContext;
    private final XAWork xaWork;
    private WorkListener workListener = NULL_WORK_LISTENER;
    private WorkException workException;
    private CountDownLatch startLatch = new CountDownLatch(1);
    private CountDownLatch endLatch = new CountDownLatch(1);

    public WorkerContext(Work work, XAWork xaWork) {
        this.adaptee = work;
        this.executionContext = null;
        this.xaWork = xaWork;
    }

    public WorkerContext(Work aWork, long aStartTimeout, ExecutionContext execContext, XAWork xaWork, WorkListener workListener) {
        this.adaptee = aWork;
        this.startTimeOut = aStartTimeout;
        this.executionContext = execContext;
        this.xaWork = xaWork;
        if (null != workListener) {
            this.workListener = workListener;
        }
    }

    public void release() {
        this.adaptee.release();
    }

    public void setThreadPriority(int aPriority) {
        this.threadPriority = aPriority;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public synchronized void workAccepted(Object anObject) {
        this.isAccepted = true;
        this.acceptedTime = System.currentTimeMillis();
        this.workListener.workAccepted(new WorkEvent(anObject, 1, this.adaptee, null));
    }

    public synchronized long getAcceptedTime() {
        return this.acceptedTime;
    }

    public long getStartTimeout() {
        return this.startTimeOut;
    }

    public synchronized boolean isTimedOut() {
        boolean isTimeout;
        assert (this.isAccepted) : "The work is not accepted.";
        if (0L == this.startTimeOut || this.startTimeOut == Long.MAX_VALUE) {
            return false;
        }
        boolean bl = isTimeout = this.acceptedTime + this.startTimeOut > 0L && System.currentTimeMillis() > this.acceptedTime + this.startTimeOut;
        if (log.isDebugEnabled()) {
            log.debug(this + " accepted at " + this.acceptedTime + (isTimeout ? " has timed out." : " has not timed out. ") + this.nbRetry + " retries have been performed.");
        }
        if (isTimeout) {
            this.workException = new WorkRejectedException(this + " has timed out.", "1");
            this.workListener.workRejected(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
            return true;
        }
        ++this.nbRetry;
        return isTimeout;
    }

    public synchronized WorkException getWorkException() {
        return this.workException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isTimedOut()) {
            this.startLatch.countDown();
            this.endLatch.countDown();
            return;
        }
        this.workListener.workStarted(new WorkEvent((Object)this, 3, this.adaptee, null));
        this.startLatch.countDown();
        try {
            if (this.executionContext == null || this.executionContext.getXid() == null) {
                this.adaptee.run();
            } else {
                try {
                    long transactionTimeout = this.executionContext.getTransactionTimeout();
                    this.xaWork.begin(this.executionContext.getXid(), transactionTimeout < 0L ? 0L : transactionTimeout);
                }
                catch (XAException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause((Throwable)e);
                }
                catch (InvalidTransactionException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause((Throwable)e);
                }
                catch (SystemException e) {
                    throw new WorkCompletedException("Transaction import failed for xid " + this.executionContext.getXid(), "3").initCause((Throwable)e);
                }
                catch (ImportedTransactionActiveException e) {
                    throw new WorkCompletedException("Transaction already active for xid " + this.executionContext.getXid(), "2").initCause((Throwable)e);
                }
                try {
                    this.adaptee.run();
                }
                finally {
                    this.xaWork.end(this.executionContext.getXid());
                }
            }
            this.workListener.workCompleted(new WorkEvent((Object)this, 4, this.adaptee, null));
        }
        catch (Throwable e) {
            this.workException = (WorkException)(e instanceof WorkCompletedException ? e : new WorkCompletedException("Unknown error", "0").initCause(e));
            this.workListener.workCompleted(new WorkEvent((Object)this, 2, this.adaptee, this.workException));
        }
        finally {
            this.endLatch.countDown();
        }
    }

    public synchronized CountDownLatch provideStartLatch() {
        return this.startLatch;
    }

    public synchronized CountDownLatch provideEndLatch() {
        return this.endLatch;
    }

    public String toString() {
        return "Work :" + this.adaptee;
    }
}

