/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;

public class MultiPoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    private final ConnectionInterceptor next;
    private final PoolingSupport singlePoolFactory;
    private final boolean useSubject;
    private final boolean useCRI;
    private final Map<SubjectCRIKey, PoolingAttributes> pools = new HashMap<SubjectCRIKey, PoolingAttributes>();
    private volatile boolean destroyed = false;

    public MultiPoolConnectionInterceptor(ConnectionInterceptor next, PoolingSupport singlePoolFactory, boolean useSubject, boolean useCRI) {
        this.next = next;
        this.singlePoolFactory = singlePoolFactory;
        this.useSubject = useSubject;
        this.useCRI = useCRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        SubjectCRIKey key = new SubjectCRIKey(this.useSubject ? mci.getSubject() : null, this.useCRI ? mci.getConnectionRequestInfo() : null);
        ConnectionInterceptor poolInterceptor = null;
        Map<SubjectCRIKey, PoolingAttributes> map = this.pools;
        synchronized (map) {
            if (this.destroyed) {
                throw new ResourceException("ConnectionManaged has been destroyed");
            }
            poolInterceptor = (ConnectionInterceptor)((Object)this.pools.get(key));
            if (poolInterceptor == null) {
                poolInterceptor = this.singlePoolFactory.addPoolingInterceptors(this.next);
                this.pools.put(key, (PoolingAttributes)((Object)poolInterceptor));
            }
        }
        mci.setPoolInterceptor(poolInterceptor);
        poolInterceptor.getConnection(connectionInfo);
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ConnectionInterceptor poolInterceptor = mci.getPoolInterceptor();
        poolInterceptor.returnConnection(connectionInfo, connectionReturnAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map<SubjectCRIKey, PoolingAttributes> map = this.pools;
        synchronized (map) {
            this.destroyed = true;
            for (PoolingAttributes poolingAttributes : this.pools.values()) {
                ConnectionInterceptor poolInterceptor = (ConnectionInterceptor)((Object)poolingAttributes);
                poolInterceptor.destroy();
            }
            this.pools.clear();
        }
        this.next.destroy();
    }

    public int getPartitionCount() {
        return this.pools.size();
    }

    public int getPartitionMaxSize() {
        return this.singlePoolFactory.getPartitionMaxSize();
    }

    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.singlePoolFactory.setPartitionMaxSize(maxSize);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setPartitionMaxSize(maxSize);
        }
    }

    public int getPartitionMinSize() {
        return this.singlePoolFactory.getPartitionMinSize();
    }

    public void setPartitionMinSize(int minSize) {
        this.singlePoolFactory.setPartitionMinSize(minSize);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setPartitionMinSize(minSize);
        }
    }

    public int getIdleConnectionCount() {
        int count = 0;
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            count += poolingAttributes.getIdleConnectionCount();
        }
        return count;
    }

    public int getConnectionCount() {
        int count = 0;
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            count += poolingAttributes.getConnectionCount();
        }
        return count;
    }

    public int getBlockingTimeoutMilliseconds() {
        return this.singlePoolFactory.getBlockingTimeoutMilliseconds();
    }

    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.singlePoolFactory.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        }
    }

    public int getIdleTimeoutMinutes() {
        return this.singlePoolFactory.getIdleTimeoutMinutes();
    }

    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.singlePoolFactory.setIdleTimeoutMinutes(idleTimeoutMinutes);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setIdleTimeoutMinutes(idleTimeoutMinutes);
        }
    }

    static class SubjectCRIKey {
        private final Subject subject;
        private final ConnectionRequestInfo cri;
        private final int hashcode;

        public SubjectCRIKey(Subject subject, ConnectionRequestInfo cri) {
            this.subject = subject;
            this.cri = cri;
            this.hashcode = (subject == null ? 17 : subject.hashCode() * 17) ^ (cri == null ? 1 : cri.hashCode());
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectCRIKey that = (SubjectCRIKey)o;
            if (this.hashcode != that.hashcode) {
                return false;
            }
            if (this.cri != null ? !this.cri.equals(that.cri) : that.cri != null) {
                return false;
            }
            return !(this.subject != null ? !this.subject.equals(that.subject) : that.subject != null);
        }
    }
}

