/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collection;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTrackingInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final String key;
    private final ConnectionTracker connectionTracker;

    public ConnectionTrackingInterceptor(ConnectionInterceptor next, String key, ConnectionTracker connectionTracker) {
        this.next = next;
        this.key = key;
        this.connectionTracker = connectionTracker;
    }

    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.connectionTracker.setEnvironment(connectionInfo, this.key);
        this.next.getConnection(connectionInfo);
        this.connectionTracker.handleObtained(this, connectionInfo, false);
    }

    public void reassociateConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.connectionTracker.setEnvironment(connectionInfo, this.key);
        this.next.getConnection(connectionInfo);
        this.connectionTracker.handleObtained(this, connectionInfo, true);
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.connectionTracker.handleReleased(this, connectionInfo, connectionReturnAction);
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    @Override
    public void destroy() {
        this.next.destroy();
    }

    public void enter(Collection<ConnectionInfo> connectionInfos) throws ResourceException {
        for (ConnectionInfo connectionInfo : connectionInfos) {
            this.next.getConnection(connectionInfo);
        }
    }

    public void exit(Collection<ConnectionInfo> connectionInfos) throws ResourceException {
        Iterator<ConnectionInfo> iterator = connectionInfos.iterator();
        while (iterator.hasNext()) {
            ConnectionInfo connectionInfo = iterator.next();
            if (connectionInfo.isUnshareable()) {
                return;
            }
            ManagedConnectionInfo managedConnectionInfo = connectionInfo.getManagedConnectionInfo();
            ManagedConnection managedConnection = managedConnectionInfo.getManagedConnection();
            if (!(managedConnection instanceof DissociatableManagedConnection) || !managedConnectionInfo.isFirstConnectionInfo(connectionInfo)) continue;
            iterator.remove();
            ((DissociatableManagedConnection)managedConnection).dissociateConnections();
            managedConnectionInfo.clearConnectionHandles();
            this.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
        }
    }
}

