/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntrySource;

public class DirectoryCache {
    protected final Map<String, CachedEntry> entryStore = new HashMap<String, CachedEntry>();
    protected final Map<String, CachedEntry> entryStoreWithoutReferences = new HashMap<String, CachedEntry>();
    protected int timeout = 0;
    protected int maxSize = 0;

    protected boolean isCacheEnabled() {
        return this.maxSize > 0;
    }

    public DocumentModel getEntry(String entryId, EntrySource source) throws DirectoryException {
        return this.getEntry(entryId, source, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel getEntry(String entryId, EntrySource source, boolean fetchReferences) throws DirectoryException {
        DocumentModel dm;
        CachedEntry entry;
        if (!this.isCacheEnabled()) {
            return source.getEntryFromSource(entryId, fetchReferences);
        }
        if (fetchReferences) {
            entry = this.entryStore.get(entryId);
            if (entry == null || entry.isExpired()) {
                dm = source.getEntryFromSource(entryId, fetchReferences);
                DirectoryCache directoryCache = this;
                synchronized (directoryCache) {
                    if (this.maxSize > 0 && this.entryStore.size() >= this.maxSize) {
                        this.entryStore.clear();
                    }
                    this.entryStore.put(entryId, new CachedEntry(dm, this.timeout));
                }
            } else {
                dm = entry.getDocumentModel();
            }
        } else {
            entry = this.entryStoreWithoutReferences.get(entryId);
            if (entry == null || entry.isExpired()) {
                dm = source.getEntryFromSource(entryId, fetchReferences);
                DirectoryCache directoryCache = this;
                synchronized (directoryCache) {
                    if (this.maxSize > 0 && this.entryStoreWithoutReferences.size() >= this.maxSize) {
                        this.entryStoreWithoutReferences.clear();
                    }
                    this.entryStoreWithoutReferences.put(entryId, new CachedEntry(dm, this.timeout));
                }
            } else {
                dm = entry.getDocumentModel();
            }
        }
        try {
            if (dm == null) {
                return null;
            }
            DocumentModel clone = dm.clone();
            if (BaseSession.isReadOnlyEntry(dm)) {
                BaseSession.setReadOnlyEntry(clone);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return dm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(List<String> entryIds) {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                for (String entryId : entryIds) {
                    this.entryStore.remove(entryId);
                    this.entryStoreWithoutReferences.remove(entryId);
                }
            }
        }
    }

    public void invalidate(String ... entryIds) {
        this.invalidate(Arrays.asList(entryIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        if (this.isCacheEnabled()) {
            DirectoryCache directoryCache = this;
            synchronized (directoryCache) {
                this.entryStore.clear();
                this.entryStoreWithoutReferences.clear();
            }
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    protected static class CachedEntry {
        protected final DocumentModel entry;
        protected final Calendar expirationDate;

        CachedEntry(DocumentModel entry, int timeout) {
            this.entry = entry;
            this.expirationDate = Calendar.getInstance();
            this.expirationDate.add(13, timeout);
        }

        public DocumentModel getDocumentModel() {
            return this.entry;
        }

        public boolean isExpired() {
            return this.expirationDate.before(Calendar.getInstance());
        }
    }
}

