/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.directory.Session;

public abstract class BaseSession
implements Session {
    protected static final String READONLY_ENTRY_FLAG = "READONLY_ENTRY";

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values) throws PropertyException {
        DataModelImpl dataModel;
        DocumentModelImpl entry = new DocumentModelImpl(sessionId, schema, id, null, null, null, null, new String[]{schema}, new HashSet(), null, null);
        if (values == null) {
            dataModel = new DataModelImpl(schema, Collections.emptyMap());
        } else {
            dataModel = new DataModelImpl(schema);
            dataModel.setMap(values);
        }
        entry.addDataModel((DataModel)dataModel);
        return entry;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values, boolean readOnly) throws PropertyException {
        DocumentModel entry = BaseSession.createEntryModel(sessionId, schema, id, values);
        if (readOnly) {
            BaseSession.setReadOnlyEntry(entry);
        }
        return entry;
    }

    protected static Map<String, Serializable> mkSerializableMap(Map<String, Object> map) {
        HashMap<String, Serializable> serializableMap = null;
        if (map != null) {
            serializableMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                serializableMap.put(key, (Serializable)map.get(key));
            }
        }
        return serializableMap;
    }

    protected static Map<String, Object> mkObjectMap(Map<String, Serializable> map) {
        HashMap<String, Serializable> objectMap = null;
        if (map != null) {
            objectMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                objectMap.put(key, map.get(key));
            }
        }
        return objectMap;
    }

    public static boolean isReadOnlyEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        return contextData.getScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG) == Boolean.TRUE;
    }

    public static void setReadOnlyEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        contextData.putScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG, (Serializable)Boolean.TRUE);
    }

    public static void setReadWriteEntry(DocumentModel entry) {
        ScopedMap contextData = entry.getContextData();
        contextData.putScopedValue(ScopeType.REQUEST, READONLY_ENTRY_FLAG, (Serializable)Boolean.FALSE);
    }
}

