/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.exe;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.taskmgmt.exe.SwimlaneInstance;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.util.EqualsUtil;

public class PooledActor
implements Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    int version = 0;
    protected String actorId = null;
    protected Set taskInstances = null;
    protected SwimlaneInstance swimlaneInstance = null;

    public static Set createPool(String[] actorIds, SwimlaneInstance swimlaneInstance, TaskInstance taskInstance) {
        HashSet<PooledActor> pooledActors = new HashSet<PooledActor>();
        for (int i = 0; i < actorIds.length; ++i) {
            PooledActor pooledActor = new PooledActor(actorIds[i]);
            if (swimlaneInstance != null) {
                pooledActor.setSwimlaneInstance(swimlaneInstance);
            }
            if (taskInstance != null) {
                pooledActor.addTaskInstance(taskInstance);
            }
            pooledActors.add(pooledActor);
        }
        return pooledActors;
    }

    public static Set extractActorIds(Set poooledActors) {
        HashSet<String> extractedActorIds = null;
        if (poooledActors != null) {
            extractedActorIds = new HashSet<String>();
            for (PooledActor pooledActor : poooledActors) {
                extractedActorIds.add(pooledActor.getActorId());
            }
        }
        return extractedActorIds;
    }

    public PooledActor() {
    }

    public PooledActor(String actorId) {
        this.actorId = actorId;
    }

    public void addTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances == null) {
            this.taskInstances = new HashSet();
        }
        this.taskInstances.add(taskInstance);
    }

    public Set getTaskInstances() {
        return this.taskInstances;
    }

    public void removeTaskInstance(TaskInstance taskInstance) {
        if (this.taskInstances != null) {
            this.taskInstances.remove(taskInstance);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String toString() {
        return "PooledActor(" + this.actorId + ")";
    }

    public String getActorId() {
        return this.actorId;
    }

    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    public SwimlaneInstance getSwimlaneInstance() {
        return this.swimlaneInstance;
    }

    public void setSwimlaneInstance(SwimlaneInstance swimlaneInstance) {
        this.swimlaneInstance = swimlaneInstance;
    }

    public long getId() {
        return this.id;
    }
}

