/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Map;
import org.jbpm.JbpmContext;
import org.jbpm.command.Command;
import org.jbpm.context.exe.VariableContainer;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class VariablesCommand
implements Command {
    private static final long serialVersionUID = 1L;
    long tokenId = 0L;
    long taskInstanceId = 0L;
    Map variables = null;
    ProcessInstance previousProcessInstance = null;
    Token previousToken = null;
    TaskInstance previousTaskInstance = null;

    public Object execute(JbpmContext jbpmContext) throws Exception {
        VariableContainer variableContainer = this.getVariableContainer(jbpmContext);
        if (variableContainer != null && this.variables != null) {
            variableContainer.addVariables(this.variables);
        }
        return variableContainer;
    }

    protected VariableContainer getVariableContainer(JbpmContext jbpmContext) {
        if (this.previousProcessInstance != null) {
            return this.getVariableContainer(this.previousProcessInstance.getRootToken());
        }
        if (this.previousToken != null) {
            return this.getVariableContainer(this.previousToken);
        }
        if (this.previousTaskInstance != null) {
            return this.previousTaskInstance;
        }
        if (this.tokenId != 0L) {
            return this.getVariableContainer(jbpmContext.getToken(this.tokenId));
        }
        if (this.taskInstanceId != 0L) {
            return jbpmContext.getTaskInstance(this.taskInstanceId);
        }
        return null;
    }

    protected VariableContainer getVariableContainer(Token token) {
        return token.getProcessInstance().getContextInstance().getTokenVariableMap(token);
    }

    public long getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(long taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public long getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(long tokenId) {
        this.tokenId = tokenId;
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }
}

