/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractGetObjectBaseCommand;
import org.jbpm.command.Command;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class GetTaskListCommand
extends AbstractGetObjectBaseCommand
implements Command {
    private static final long serialVersionUID = -1627380259541998349L;
    static final Log log = LogFactory.getLog(GetTaskListCommand.class);
    private String[] actor;

    public GetTaskListCommand(String[] actor) {
        this.setActor(actor);
    }

    public GetTaskListCommand(String actor, boolean includeVariables) {
        super(includeVariables, false);
        this.setActor(actor);
    }

    public GetTaskListCommand(String actor, String[] variablesToInclude) {
        super(variablesToInclude);
        this.setActor(actor);
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.setJbpmContext(jbpmContext);
        ArrayList result = null;
        if (this.actor == null || this.actor.length == 0) {
            result = jbpmContext.getTaskList();
        } else {
            result = new ArrayList();
            for (int i = 0; i < this.actor.length; ++i) {
                result.addAll(jbpmContext.getTaskList(this.actor[i]));
            }
            result.addAll(jbpmContext.getGroupTaskList(Arrays.asList(this.actor)));
        }
        return this.retrieveTaskInstanceDetails(result);
    }

    public List retrieveTaskInstanceDetails(List taskInstanceList) {
        Iterator iter = taskInstanceList.iterator();
        while (iter.hasNext()) {
            this.retrieveTaskInstanceDetails((TaskInstance)iter.next());
        }
        return taskInstanceList;
    }

    public String[] getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = new String[]{actor};
    }

    public void setActor(String[] actor) {
        this.actor = actor;
    }
}

