/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.Pattern;
import org.jboss.seam.web.Rewrite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritingResponse
extends HttpServletResponseWrapper {
    private static LogProvider log = Logging.getLogProvider(RewritingResponse.class);
    private HttpServletRequest request;
    private Collection<Pattern> patterns;

    public RewritingResponse(HttpServletRequest request, HttpServletResponse response, Collection<Pattern> patterns) {
        super(response);
        this.request = request;
        this.patterns = patterns;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        String result = this.encode(url);
        log.debug("encodeURL " + url + " -> " + result);
        return result;
    }

    public String encodeRedirectURL(String url) {
        log.debug("encode redirectURL called with " + url);
        return this.encodeURL(url);
    }

    public String encode(String originalUrl) {
        String url = originalUrl;
        String contextPath = this.request.getContextPath();
        if (url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        for (Pattern pattern : this.patterns) {
            Rewrite rewrite = pattern.matchOutgoing(url);
            if (rewrite == null) continue;
            return this.request.getContextPath() + rewrite.rewrite();
        }
        return originalUrl;
    }
}

