/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.permission.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.security.management.IdentityManager;
import org.jboss.seam.security.permission.Permission;
import org.jboss.seam.security.permission.PermissionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="org.jboss.seam.security.permission.permissionSearch")
@Install(precedence=0)
public class PermissionSearch
implements Serializable {
    private Map<Principal, List<Permission>> groupedPermissions = new HashMap<Principal, List<Permission>>();
    @DataModel
    List<Principal> recipients;
    @DataModelSelection
    Principal selectedRecipient;
    @In
    IdentityManager identityManager;
    @In
    PermissionManager permissionManager;
    private Object target;

    @Begin
    public void search(Object target) {
        this.target = target;
    }

    public void refresh() {
        List<Permission> permissions = this.permissionManager.listPermissions(this.target);
        this.groupedPermissions.clear();
        for (Permission permission : permissions) {
            List<Object> recipientPermissions = null;
            if (!this.groupedPermissions.containsKey(permission.getRecipient())) {
                recipientPermissions = new ArrayList();
                this.groupedPermissions.put(permission.getRecipient(), recipientPermissions);
            } else {
                recipientPermissions = this.groupedPermissions.get(permission.getRecipient());
            }
            recipientPermissions.add(permission);
        }
        this.recipients = new ArrayList<Principal>(this.groupedPermissions.keySet());
    }

    public String getActions(Principal recipient) {
        StringBuilder sb = new StringBuilder();
        for (Permission permission : this.groupedPermissions.get(recipient)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(permission.getAction());
        }
        return sb.toString();
    }

    public Object getTarget() {
        return this.target;
    }

    public void revokeSelected() {
        this.permissionManager.revokePermissions(this.getSelectedPermissions());
        this.refresh();
    }

    public Principal getSelectedRecipient() {
        return this.selectedRecipient;
    }

    public List<Permission> getSelectedPermissions() {
        return this.groupedPermissions.get(this.selectedRecipient);
    }
}

