/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.io.Serializable;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PassivatedEntity
implements Serializable {
    private static final long serialVersionUID = 6565440294007267788L;
    private Object id;
    private Object version;
    private String persistenceContext;
    private Class<?> entityClass;

    private PassivatedEntity(Object id, Object version, Class<?> entityClass, String persistenceContext) {
        this.id = id;
        this.persistenceContext = persistenceContext;
        this.entityClass = entityClass;
        this.version = version;
    }

    private String getPersistenceContext() {
        return this.persistenceContext;
    }

    private Object getId() {
        return this.id;
    }

    private Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean isVersioned() {
        return this.version != null;
    }

    public Object toEntityReference(boolean checkVersion) {
        Object persistenceContext = Component.getInstance(this.getPersistenceContext());
        if (persistenceContext == null) {
            return null;
        }
        if (persistenceContext instanceof EntityManager) {
            return this.getEntityFromEntityManager(persistenceContext, checkVersion);
        }
        return this.getEntityFromHibernate(persistenceContext, checkVersion);
    }

    private Object getEntityFromHibernate(Object persistenceContext, boolean checkVersion) {
        Session session = (Session)persistenceContext;
        if (session.isOpen()) {
            Object result = session.load(this.getEntityClass(), (Serializable)this.getId());
            if (result != null && checkVersion) {
                this.checkVersion(session, result);
            }
            return result;
        }
        return null;
    }

    private void checkVersion(Session session, Object result) {
        Object version = HibernatePersistenceProvider.getVersion(result, session);
        if (version != null) {
            HibernatePersistenceProvider.checkVersion(result, session, this.version, version);
        }
    }

    private Object getEntityFromEntityManager(Object persistenceContext, boolean checkVersion) {
        EntityManager em = (EntityManager)persistenceContext;
        if (em.isOpen()) {
            Object result = em.getReference(this.getEntityClass(), this.getId());
            if (result != null && checkVersion) {
                this.checkVersion(em, result);
            }
            return result;
        }
        return null;
    }

    private void checkVersion(EntityManager em, Object result) {
        Object version = PersistenceProvider.instance().getVersion(result, em);
        if (version != null) {
            PersistenceProvider.instance().checkVersion(result, em, this.version, version);
        }
    }

    public static PassivatedEntity passivateEntity(Object value) {
        Iterator<String> i$;
        Class entityClass = Seam.getEntityClass(value.getClass());
        if (entityClass != null && (i$ = PersistenceContexts.instance().getTouchedContexts().iterator()).hasNext()) {
            String persistenceContextName = i$.next();
            Object persistenceContext = Component.getInstance(persistenceContextName);
            return PassivatedEntity.createPassivatedEntity(value, entityClass, persistenceContextName, persistenceContext);
        }
        return null;
    }

    private static PassivatedEntity createPassivatedEntity(Object value, Class entityClass, String persistenceContextName, Object persistenceContext) {
        if (persistenceContext instanceof EntityManager) {
            return PassivatedEntity.createUsingEntityManager(value, entityClass, persistenceContextName, persistenceContext);
        }
        return PassivatedEntity.createUsingHibernate(value, entityClass, persistenceContextName, persistenceContext);
    }

    private static PassivatedEntity createUsingHibernate(Object value, Class entityClass, String persistenceContextName, Object persistenceContext) {
        Session session = (Session)persistenceContext;
        if (PassivatedEntity.isManaged(value, session)) {
            Serializable id = session.getIdentifier(value);
            Object version = HibernatePersistenceProvider.getVersion(value, session);
            return PassivatedEntity.create(entityClass, persistenceContextName, id, version);
        }
        return null;
    }

    private static boolean isManaged(Object value, Session session) {
        boolean managed;
        try {
            managed = session.isOpen() && session.contains(value);
        }
        catch (RuntimeException re) {
            managed = false;
        }
        return managed;
    }

    private static PassivatedEntity createUsingEntityManager(Object value, Class entityClass, String persistenceContextName, Object persistenceContext) {
        EntityManager em = (EntityManager)persistenceContext;
        if (PassivatedEntity.isManaged(value, em)) {
            Object id = PersistenceProvider.instance().getId(value, em);
            Object version = PersistenceProvider.instance().getVersion(value, em);
            return PassivatedEntity.create(entityClass, persistenceContextName, id, version);
        }
        return null;
    }

    private static boolean isManaged(Object value, EntityManager em) {
        boolean managed;
        try {
            managed = em.isOpen() && em.contains(value);
        }
        catch (RuntimeException re) {
            managed = false;
        }
        return managed;
    }

    private static PassivatedEntity create(Class entityClass, String persistenceContextName, Object id, Object version) {
        if (id == null) {
            return null;
        }
        return new PassivatedEntity(id, version, entityClass, persistenceContextName);
    }

    static boolean isTransactionRolledBackOrMarkedRollback() {
        try {
            return Transaction.instance().isRolledBackOrMarkedRollback();
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return this.entityClass + "#" + this.id;
    }
}

