/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.api;

import java.io.Serializable;
import java.util.List;

public class ExecResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String commandLine;
    protected final List<String> output;
    protected final long execTime;
    protected boolean success;
    protected final Exception error;
    protected int returnCode;

    public ExecResult(String commandLine, List<String> output, long execTime, int returnCode) {
        this.commandLine = commandLine;
        this.execTime = execTime;
        this.output = output;
        this.returnCode = returnCode;
        this.success = true;
        this.error = null;
        if (returnCode != 0) {
            this.success = false;
        }
    }

    public ExecResult(String commandLine, Exception error) {
        this.error = error;
        this.commandLine = commandLine;
        this.execTime = 0L;
        this.output = null;
        this.success = false;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Exception getError() {
        return this.error;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getCommandLine() {
        return this.commandLine;
    }
}

