/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.dynamic;

import java.lang.reflect.Field;
import java.util.LinkedList;
import org.mvel2.optimizers.dynamic.DynamicAccessor;
import org.mvel2.util.MVELClassLoader;
import sun.misc.Unsafe;

public class DynamicClassLoader
extends ClassLoader
implements MVELClassLoader {
    private int totalClasses;
    private int tenureLimit;
    private final LinkedList<DynamicAccessor> allAccessors = new LinkedList();
    private static boolean sunJVM;
    private static Object sunUnsafe;

    public DynamicClassLoader(ClassLoader classLoader, int tenureLimit) {
        super(classLoader);
        this.tenureLimit = tenureLimit;
    }

    public Class defineClassX(String className, byte[] b, int start, int end) {
        ++this.totalClasses;
        if (sunJVM) {
            return ((Unsafe)sunUnsafe).defineClass(className, b, start, end);
        }
        return super.defineClass(className, b, start, end);
    }

    public int getTotalClasses() {
        return this.totalClasses;
    }

    public DynamicAccessor registerDynamicAccessor(DynamicAccessor accessor) {
        this.allAccessors.add(accessor);
        assert (accessor != null);
        return accessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deoptimizeAll() {
        LinkedList<DynamicAccessor> linkedList = this.allAccessors;
        synchronized (linkedList) {
            for (DynamicAccessor a : this.allAccessors) {
                if (a == null) continue;
                a.deoptimize();
            }
        }
    }

    public boolean isOverloaded() {
        return this.tenureLimit < this.totalClasses;
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            sunUnsafe = f.get(null);
            sunJVM = true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            sunJVM = false;
        }
    }
}

