/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.service;

import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerHook;
import org.nuxeo.ecm.platform.ec.notification.UserSubscription;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.platform.ec.notification.service.GeneralSettingsDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationEventDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationListenerHookDescriptor;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationRegistryImpl;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.notification.service.TemplateDescriptor;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.ecm.platform.notification.api.Notification;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.notification.api.NotificationRegistry;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class NotificationService
extends DefaultComponent
implements NotificationManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.ec.notification.service.NotificationService");
    private static final Log log = LogFactory.getLog(NotificationService.class);
    public static final String SUBSCRIPTION_NAME = "UserSubscription";
    protected static final String NOTIFICATIONS_EP = "notifications";
    protected static final String TEMPLATES_EP = "templates";
    protected static final String GENERAL_SETTINGS_EP = "generalSettings";
    protected static final String NOTIFICATION_HOOK_EP = "notificationListenerHook";
    protected static final Map<String, URL> TEMPLATES_MAP = new HashMap<String, URL>();
    protected EmailHelper emailHelper = new EmailHelper();
    protected GeneralSettingsDescriptor generalSettings;
    protected NotificationRegistry notificationRegistry;
    protected DocumentViewCodecManager docLocator;
    protected final Map<String, NotificationListenerHook> hookListeners = new HashMap<String, NotificationListenerHook>();
    protected EventProducer producer;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(NotificationManager.class)) {
            return (T)((Object)this);
        }
        return null;
    }

    public void activate(ComponentContext context) throws Exception {
        this.notificationRegistry = new NotificationRegistryImpl();
        this.generalSettings = new GeneralSettingsDescriptor();
        this.generalSettings.serverPrefix = "http://localhost:8080/nuxeo/";
        this.generalSettings.eMailSubjectPrefix = "[Nuxeo]";
        this.generalSettings.mailSessionJndiName = "java:/Mail";
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.notificationRegistry.clear();
        this.notificationRegistry = null;
    }

    public void registerExtension(Extension extension) throws Exception {
        block13: {
            Object[] contribs;
            String xp;
            block15: {
                Object[] contribs2;
                block14: {
                    Object[] contribs3;
                    block12: {
                        Object[] contribs4;
                        log.info((Object)"Registering notification extension");
                        xp = extension.getExtensionPoint();
                        if (!NOTIFICATIONS_EP.equals(xp)) break block12;
                        for (Object contrib : contribs4 = extension.getContributions()) {
                            try {
                                NotificationDescriptor notifDesc = (NotificationDescriptor)contrib;
                                this.notificationRegistry.registerNotification((Notification)notifDesc, NotificationService.getNames(notifDesc.getEvents()));
                            }
                            catch (Exception e) {
                                log.error((Object)e);
                            }
                        }
                        break block13;
                    }
                    if (!TEMPLATES_EP.equals(xp)) break block14;
                    for (Object contrib : contribs3 = extension.getContributions()) {
                        try {
                            TemplateDescriptor templateDescriptor = (TemplateDescriptor)contrib;
                            templateDescriptor.setContext(extension.getContext());
                            NotificationService.registerTemplate(templateDescriptor);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                    break block13;
                }
                if (!GENERAL_SETTINGS_EP.equals(xp)) break block15;
                for (Object contrib : contribs2 = extension.getContributions()) {
                    try {
                        this.registerGeneralSettings((GeneralSettingsDescriptor)contrib);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                break block13;
            }
            if (!NOTIFICATION_HOOK_EP.equals(xp)) break block13;
            for (Object contrib : contribs = extension.getContributions()) {
                try {
                    NotificationListenerHookDescriptor desc = (NotificationListenerHookDescriptor)contrib;
                    Class<? extends NotificationListenerHook> clazz = desc.hookListener;
                    NotificationListenerHook hookListener = clazz.newInstance();
                    this.registerHookListener(desc.name, hookListener);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    private void registerHookListener(String name, NotificationListenerHook hookListener) {
        this.hookListeners.put(name, hookListener);
    }

    protected void registerGeneralSettings(GeneralSettingsDescriptor desc) {
        this.generalSettings = desc;
        this.generalSettings.serverPrefix = Framework.expandVars((String)this.generalSettings.serverPrefix);
        this.generalSettings.eMailSubjectPrefix = Framework.expandVars((String)this.generalSettings.eMailSubjectPrefix);
        this.generalSettings.mailSessionJndiName = Framework.expandVars((String)this.generalSettings.mailSessionJndiName);
    }

    private static List<String> getNames(List<NotificationEventDescriptor> events) {
        ArrayList<String> eventNames = new ArrayList<String>();
        for (NotificationEventDescriptor descriptor : events) {
            eventNames.add(descriptor.name);
        }
        return eventNames;
    }

    public void unregisterExtension(Extension extension) throws Exception {
        block7: {
            Object[] contribs;
            String xp;
            block6: {
                Object[] contribs2;
                xp = extension.getExtensionPoint();
                if (!NOTIFICATIONS_EP.equals(xp)) break block6;
                for (Object contrib : contribs2 = extension.getContributions()) {
                    try {
                        NotificationDescriptor notifDesc = (NotificationDescriptor)contrib;
                        this.notificationRegistry.unregisterNotification((Notification)notifDesc, NotificationService.getNames(notifDesc.getEvents()));
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                    }
                }
                break block7;
            }
            if (!TEMPLATES_EP.equals(xp)) break block7;
            for (Object contrib : contribs = extension.getContributions()) {
                try {
                    TemplateDescriptor templateDescriptor = (TemplateDescriptor)contrib;
                    templateDescriptor.setContext(extension.getContext());
                    NotificationService.unregisterTemplate(templateDescriptor);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public NotificationRegistry getNotificationRegistry() {
        return this.notificationRegistry;
    }

    public List<String> getSubscribers(String notification, String docId) throws ClientException {
        PlacefulService service;
        try {
            service = NotificationServiceHelper.getPlacefulService();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        String className = (String)service.getAnnotationRegistry().get(SUBSCRIPTION_NAME);
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("notification", notification);
        paramMap.put("docId", docId);
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        List subscriptions = new ArrayList();
        subscriptions = serviceBean.getAnnotationListByParamMap(paramMap, shortClassName);
        ArrayList<String> subscribers = new ArrayList<String>();
        for (Annotation obj : subscriptions) {
            UserSubscription subscription = (UserSubscription)obj;
            subscribers.add(subscription.getUserId());
        }
        return subscribers;
    }

    public List<String> getSubscriptionsForUserOnDocument(String username, String docId) throws ClassNotFoundException, ClientException {
        PlacefulService service;
        try {
            service = NotificationServiceHelper.getPlacefulService();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        String className = (String)service.getAnnotationRegistry().get(SUBSCRIPTION_NAME);
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (username != null) {
            paramMap.put("userId", username);
        }
        if (docId != null) {
            paramMap.put("docId", docId);
        }
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        List subscriptions = serviceBean.getAnnotationListByParamMap(paramMap, shortClassName);
        ArrayList<String> subscribers = new ArrayList<String>();
        for (Annotation obj : subscriptions) {
            UserSubscription subscription = (UserSubscription)obj;
            subscribers.add(subscription.getNotification());
        }
        return subscribers;
    }

    public void addSubscription(String username, String notification, DocumentModel doc, Boolean sendConfirmationEmail, NuxeoPrincipal principal, String notificationName) throws ClientException {
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        UserSubscription subscription = new UserSubscription(notification, username, doc.getId());
        serviceBean.setAnnotation((Annotation)subscription);
        if (sendConfirmationEmail.booleanValue()) {
            this.raiseConfirmationEvent(principal, doc, username, notificationName);
        }
    }

    protected void doFireEvent(Event event) throws ClientException {
        if (this.producer == null) {
            try {
                this.producer = (EventProducer)Framework.getService(EventProducer.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException("Unable to get MessageProducer : ", (Throwable)e);
            }
        }
        this.producer.fireEvent(event);
    }

    private void raiseConfirmationEvent(NuxeoPrincipal principal, DocumentModel doc, String username, String notification) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("repositoryName", doc.getRepositoryName());
        options.put("sessionId", doc.getSessionId());
        options.put("recipients", username);
        options.put("notifName", notification);
        CoreSession session = doc.getCoreSession();
        DocumentEventContext ctx = new DocumentEventContext(session, (Principal)principal, doc);
        ctx.setCategory("clientCodeNotificationCategory");
        ctx.setProperties(options);
        Event event = ctx.newEvent("subscriptionAssigned");
        try {
            this.doFireEvent(event);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Cannot fire event " + event, (Throwable)e);
        }
    }

    public void removeSubscription(String username, String notification, String docId) throws ClientException {
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userId", username);
        paramMap.put("docId", docId);
        paramMap.put("notification", notification);
        serviceBean.removeAnnotationListByParamMap(paramMap, SUBSCRIPTION_NAME);
    }

    public List<String> getUsersSubscribedToNotificationOnDocument(String notification, String docId) throws ClientException {
        PlacefulService serviceBean = NotificationServiceHelper.getPlacefulServiceBean();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("docId", docId);
        paramMap.put("notification", notification);
        ArrayList<String> subscribers = new ArrayList<String>();
        List subscriptions = serviceBean.getAnnotationListByParamMap(paramMap, SUBSCRIPTION_NAME);
        for (Annotation annoSubscription : subscriptions) {
            UserSubscription subscription = (UserSubscription)annoSubscription;
            subscribers.add(subscription.getUserId());
        }
        return subscribers;
    }

    private static void registerTemplate(TemplateDescriptor td) {
        if (td.src != null && td.src.length() > 0) {
            URL url = td.getContext().getResource(td.src);
            TEMPLATES_MAP.put(td.name, url);
        }
    }

    private static void unregisterTemplate(TemplateDescriptor td) {
        if (td.name != null) {
            TEMPLATES_MAP.remove(td.name);
        }
    }

    public static URL getTemplateURL(String name) {
        return TEMPLATES_MAP.get(name);
    }

    public String getServerUrlPrefix() {
        return this.generalSettings.getServerPrefix();
    }

    public String getEMailSubjectPrefix() {
        return this.generalSettings.getEMailSubjectPrefix();
    }

    public String getMailSessionJndiName() {
        return this.generalSettings.getMailSessionJndiName();
    }

    public Notification getNotificationByName(String selectedNotification) {
        List listNotif = this.notificationRegistry.getNotifications();
        for (Notification notification : listNotif) {
            if (!notification.getName().equals(selectedNotification)) continue;
            return notification;
        }
        return null;
    }

    public void sendNotification(String notificationName, Map<String, Object> infoMap, String userPrincipal) throws ClientException {
        String subject;
        Notification notif = this.getNotificationByName(notificationName);
        NuxeoPrincipal recipient = NotificationServiceHelper.getUsersService().getPrincipal(userPrincipal);
        DataModel model = (DataModel)recipient.getModel().getDataModels().values().iterator().next();
        String email = (String)model.getData("email");
        String mailTemplate = notif.getTemplate();
        infoMap.put("mail.to", email);
        String authorUsername = (String)infoMap.get("author");
        if (authorUsername != null) {
            NuxeoPrincipal author = NotificationServiceHelper.getUsersService().getPrincipal(authorUsername);
            infoMap.put("principalAuthor", author);
        }
        String string = subject = notif.getSubject() == null ? "Alert" : notif.getSubject();
        if (notif.getSubjectTemplate() != null) {
            subject = notif.getSubjectTemplate();
        }
        subject = NotificationServiceHelper.getNotificationService().getEMailSubjectPrefix() + " " + subject;
        infoMap.put("subject", subject);
        infoMap.put("template", mailTemplate);
        try {
            this.emailHelper.sendmail(infoMap);
        }
        catch (Exception e) {
            throw new ClientException("Failed to send notification email ", (Throwable)e);
        }
    }

    public void sendDocumentByMail(DocumentModel doc, String freemarkerTemplateName, String subject, String comment, NuxeoPrincipal sender, List<String> sendTo) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("document", doc);
        infoMap.put("subject", subject);
        infoMap.put("comment", comment);
        infoMap.put("sender", sender);
        DocumentLocationImpl docLoc = new DocumentLocationImpl(doc);
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc);
        docView.setViewId("view_documents");
        infoMap.put("docUrl", this.getDocLocator().getUrlFromDocumentView((DocumentView)docView, true, NotificationServiceHelper.getNotificationService().getServerUrlPrefix()));
        if (freemarkerTemplateName == null) {
            freemarkerTemplateName = "defaultNotifTemplate";
        }
        infoMap.put("template", freemarkerTemplateName);
        for (String to : sendTo) {
            infoMap.put("mail.to", to);
            try {
                this.emailHelper.sendmail(infoMap);
            }
            catch (Exception e) {
                log.debug((Object)("Failed to send notification email " + e));
            }
        }
    }

    private DocumentViewCodecManager getDocLocator() {
        if (this.docLocator == null) {
            try {
                this.docLocator = (DocumentViewCodecManager)Framework.getService(DocumentViewCodecManager.class);
            }
            catch (Exception e) {
                log.info((Object)"Could not get service for document view manager");
            }
        }
        return this.docLocator;
    }

    public List<Notification> getNotificationsForSubscriptions(String parentType) {
        return this.notificationRegistry.getNotificationsForSubscriptions(parentType);
    }

    public List<Notification> getNotificationsForEvents(String eventId) {
        return this.notificationRegistry.getNotificationsForEvent(eventId);
    }

    public EmailHelper getEmailHelper() {
        return this.emailHelper;
    }

    public void setEmailHelper(EmailHelper emailHelper) {
        this.emailHelper = emailHelper;
    }

    public Set<String> getNotificationEventNames() {
        return this.notificationRegistry.getNotificationEventNames();
    }

    public Collection<NotificationListenerHook> getListenerHooks() {
        return this.hookListeners.values();
    }
}

