/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler.authentication;

import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.authentication.PasswordAuthenticator;
import org.webbitserver.helpers.Base64;

public class BasicAuthenticationHandler
implements HttpHandler {
    public static final String USERNAME = "user";
    private static final String BASIC_PREFIX = "Basic ";
    private final String realm;
    private final PasswordAuthenticator authenticator;

    public BasicAuthenticationHandler(PasswordAuthenticator authenticator) {
        this(authenticator, "Secure Area");
    }

    public BasicAuthenticationHandler(PasswordAuthenticator authenticator, String realm) {
        this.realm = realm;
        this.authenticator = authenticator;
    }

    @Override
    public void handleHttpRequest(final HttpRequest request, final HttpResponse response, final HttpControl control) throws Exception {
        String authHeader = request.header("Authorization");
        if (authHeader == null) {
            this.needAuthentication(response);
        } else if (authHeader.startsWith(BASIC_PREFIX)) {
            String decoded = new String(Base64.decode(authHeader.substring(BASIC_PREFIX.length())));
            String[] pair = decoded.split(":", 2);
            if (pair.length == 2) {
                final String username = pair[0];
                String password = pair[1];
                PasswordAuthenticator.ResultCallback callback = new PasswordAuthenticator.ResultCallback(){

                    @Override
                    public void success() {
                        request.data(BasicAuthenticationHandler.USERNAME, username);
                        control.nextHandler();
                    }

                    @Override
                    public void failure() {
                        BasicAuthenticationHandler.this.needAuthentication(response);
                    }
                };
                this.authenticator.authenticate(request, username, password, callback, control);
            } else {
                this.needAuthentication(response);
            }
        }
    }

    private void needAuthentication(HttpResponse response) {
        response.status(401).header("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"").content("Need authentication").end();
    }
}

