/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpHandler;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;

public class PathMatchHandler
implements HttpHandler {
    private final Pattern pathPattern;
    private final HttpHandler httpHandler;

    public PathMatchHandler(Pattern pathPattern, HttpHandler httpHandler) {
        this.pathPattern = pathPattern;
        this.httpHandler = httpHandler;
    }

    public PathMatchHandler(String path, HttpHandler httpHandler) {
        this(Pattern.compile(path), httpHandler);
    }

    @Override
    public void handleHttpRequest(HttpRequest request, HttpResponse response, HttpControl control) throws Exception {
        String path = URI.create(request.uri()).getPath();
        Matcher matcher = this.pathPattern.matcher(path);
        if (matcher.matches()) {
            this.httpHandler.handleHttpRequest(request, response, control);
        } else {
            control.nextHandler();
        }
    }
}

