/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.webbitserver.HttpControl;
import org.webbitserver.HttpRequest;
import org.webbitserver.HttpResponse;
import org.webbitserver.handler.AbstractResourceHandler;
import org.webbitserver.handler.FileEntry;
import org.webbitserver.handler.StaticFile;
import org.webbitserver.handler.TemplateEngine;
import org.webbitserver.helpers.ClassloaderResourceHelper;

public class EmbeddedResourceHandler
extends AbstractResourceHandler {
    private final File root;
    private Class<?> clazz;

    public EmbeddedResourceHandler(String root, Executor ioThread, Class<?> clazz, TemplateEngine templateEngine) {
        super(ioThread, templateEngine);
        this.root = new File(root);
        this.clazz = clazz;
    }

    public EmbeddedResourceHandler(String root, Executor ioThread, Class<?> clazz) {
        this(root, ioThread, clazz, new StaticFile());
    }

    public EmbeddedResourceHandler(String root, Executor ioThread, TemplateEngine templateEngine) {
        this(root, ioThread, EmbeddedResourceHandler.class, templateEngine);
    }

    public EmbeddedResourceHandler(String root, Executor ioThread) {
        this(root, ioThread, EmbeddedResourceHandler.class);
    }

    public EmbeddedResourceHandler(String root, Class<?> clazz, TemplateEngine templateEngine) {
        this(root, Executors.newFixedThreadPool(4), clazz, templateEngine);
    }

    public EmbeddedResourceHandler(String root, Class<?> clazz) {
        this(root, (Executor)Executors.newFixedThreadPool(4), clazz);
    }

    public EmbeddedResourceHandler(String root, TemplateEngine templateEngine) {
        this(root, EmbeddedResourceHandler.class, templateEngine);
    }

    public EmbeddedResourceHandler(String root) {
        this(root, EmbeddedResourceHandler.class);
    }

    @Override
    protected ResourceWorker createIOWorker(HttpRequest request, HttpResponse response, HttpControl control) {
        return new ResourceWorker(request, response, control);
    }

    protected class ResourceWorker
    extends AbstractResourceHandler.IOWorker {
        private InputStream resource;
        private File file;
        private final String pathWithoutTrailingSlash;
        private final boolean isDirectory;

        protected ResourceWorker(HttpRequest request, HttpResponse response, HttpControl control) {
            super(request.uri(), request, response, control);
            this.isDirectory = this.path.endsWith("/");
            this.pathWithoutTrailingSlash = this.withoutQuery(this.isDirectory ? this.path.substring(0, this.path.length() - 1) : this.path);
        }

        @Override
        protected boolean exists() throws IOException {
            this.file = new File(EmbeddedResourceHandler.this.root, this.pathWithoutTrailingSlash);
            this.resource = this.getResource(this.file);
            return this.resource != null;
        }

        @Override
        protected boolean isDirectory() throws IOException {
            return this.isDirectory;
        }

        @Override
        protected byte[] fileBytes() throws IOException {
            if (this.resource == null || this.isDirectory()) {
                return null;
            }
            return this.read(this.resource);
        }

        @Override
        protected byte[] welcomeBytes() throws IOException {
            File welcomeFile = new File(this.file, EmbeddedResourceHandler.this.welcomeFileName);
            InputStream resourceStream = this.getResource(welcomeFile);
            return resourceStream == null ? null : this.read(resourceStream);
        }

        @Override
        protected byte[] directoryListingBytes() throws IOException {
            String subdirectory = this.file.getPath();
            Iterable<FileEntry> files = ClassloaderResourceHelper.listFilesRelativeToClass(EmbeddedResourceHandler.this.clazz, subdirectory);
            return this.isDirectory() ? EmbeddedResourceHandler.this.directoryListingFormatter.formatFileListAsHtml(files) : null;
        }

        private byte[] read(InputStream content) throws IOException {
            try {
                return this.read(content.available(), content);
            }
            catch (NullPointerException happensWhenReadingDirectoryPathInJar) {
                return null;
            }
        }

        private InputStream getResource(File file) throws IOException {
            String resourcePath = file.getPath();
            if ('/' != File.separatorChar) {
                resourcePath = resourcePath.replace(File.separatorChar, '/');
            }
            return EmbeddedResourceHandler.this.clazz.getClassLoader().getResourceAsStream(resourcePath);
        }
    }
}

