/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.security;

import org.seleniumhq.jetty7.security.SecurityHandler;
import org.seleniumhq.jetty7.server.Authentication;
import org.seleniumhq.jetty7.server.UserIdentity;

public class UserAuthentication
implements Authentication.User {
    private final String _method;
    private final UserIdentity _userIdentity;

    public UserAuthentication(String method, UserIdentity userIdentity) {
        this._method = method;
        this._userIdentity = userIdentity;
    }

    public String getAuthMethod() {
        return this._method;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    public boolean isUserInRole(UserIdentity.Scope scope, String role) {
        return this._userIdentity.isUserInRole(role, scope);
    }

    public String toString() {
        return "{User," + this.getAuthMethod() + "," + this._userIdentity + "}";
    }

    public void logout() {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout(this);
        }
    }
}

