/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.io.nio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.seleniumhq.jetty7.io.AbstractBuffer;
import org.seleniumhq.jetty7.io.Buffer;
import org.seleniumhq.jetty7.io.nio.NIOBuffer;

public class DirectNIOBuffer
extends AbstractBuffer
implements NIOBuffer {
    protected final ByteBuffer _buf;
    private ReadableByteChannel _in;
    private InputStream _inStream;
    private WritableByteChannel _out;
    private OutputStream _outStream;

    public DirectNIOBuffer(int size) {
        super(2, false);
        this._buf = ByteBuffer.allocateDirect(size);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
    }

    public DirectNIOBuffer(ByteBuffer buffer, boolean immutable) {
        super(immutable ? 0 : 2, false);
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        this._buf = buffer;
        this.setGetIndex(buffer.position());
        this.setPutIndex(buffer.limit());
    }

    public DirectNIOBuffer(File file) throws IOException {
        super(1, false);
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        this._buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        this.setGetIndex(0);
        this.setPutIndex((int)file.length());
        this._access = 0;
    }

    public boolean isDirect() {
        return true;
    }

    public byte[] array() {
        return null;
    }

    public int capacity() {
        return this._buf.capacity();
    }

    public byte peek(int position) {
        return this._buf.get(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peek(int index, byte[] b, int offset, int length) {
        int l = length;
        if (index + l > this.capacity() && (l = this.capacity() - index) == 0) {
            return -1;
        }
        if (l < 0) {
            return -1;
        }
        try {
            this._buf.position(index);
            this._buf.get(b, offset, l);
        }
        finally {
            this._buf.position(0);
        }
        return l;
    }

    public void poke(int index, byte b) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index > this.capacity()) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        this._buf.put(index, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poke(int index, Buffer src) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        byte[] array = src.array();
        if (array != null) {
            return this.poke(index, array, src.getIndex(), src.length());
        }
        Buffer src_buf = src.buffer();
        if (src_buf instanceof DirectNIOBuffer) {
            ByteBuffer src_bytebuf = ((DirectNIOBuffer)src_buf)._buf;
            if (src_bytebuf == this._buf) {
                src_bytebuf = this._buf.duplicate();
            }
            try {
                this._buf.position(index);
                int space = this._buf.remaining();
                int length = src.length();
                if (length > space) {
                    length = space;
                }
                src_bytebuf.position(src.getIndex());
                src_bytebuf.limit(src.getIndex() + length);
                this._buf.put(src_bytebuf);
                int n = length;
                return n;
            }
            finally {
                this._buf.position(0);
                src_bytebuf.limit(src_bytebuf.capacity());
                src_bytebuf.position(0);
            }
        }
        return super.poke(index, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poke(int index, byte[] b, int offset, int length) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index<0: " + index + "<0");
        }
        if (index + length > this.capacity() && (length = this.capacity() - index) < 0) {
            throw new IllegalArgumentException("index>capacity(): " + index + ">" + this.capacity());
        }
        try {
            this._buf.position(index);
            int space = this._buf.remaining();
            if (length > space) {
                length = space;
            }
            if (length > 0) {
                this._buf.put(b, offset, length);
            }
            int n = length;
            return n;
        }
        finally {
            this._buf.position(0);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this._buf;
    }

    public int readFrom(InputStream in, int max) throws IOException {
        if (this._in == null || !this._in.isOpen() || in != this._inStream) {
            this._in = Channels.newChannel(in);
            this._inStream = in;
        }
        if (max < 0 || max > this.space()) {
            max = this.space();
        }
        int p = this.putIndex();
        try {
            int len = 0;
            int total = 0;
            int available = max;
            int loop = 0;
            while (total < max) {
                this._buf.position(p);
                this._buf.limit(p + available);
                len = this._in.read(this._buf);
                if (len < 0) {
                    this._in = null;
                    this._inStream = in;
                    break;
                }
                if (len > 0) {
                    total += len;
                    available -= len;
                    this.setPutIndex(p += len);
                    loop = 0;
                } else if (loop++ > 1) break;
                if (in.available() > 0) continue;
            }
            if (len < 0 && total == 0) {
                int n = -1;
                return n;
            }
            int n = total;
            return n;
        }
        catch (IOException e) {
            this._in = null;
            this._inStream = in;
            throw e;
        }
        finally {
            if (this._in != null && !this._in.isOpen()) {
                this._in = null;
                this._inStream = in;
            }
            this._buf.position(0);
            this._buf.limit(this._buf.capacity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (this._out == null || !this._out.isOpen() || out != this._outStream) {
            this._out = Channels.newChannel(out);
            this._outStream = out;
        }
        ByteBuffer byteBuffer = this._buf;
        synchronized (byteBuffer) {
            try {
                int loop = 0;
                while (this.hasContent() && this._out.isOpen()) {
                    this._buf.position(this.getIndex());
                    this._buf.limit(this.putIndex());
                    int len = this._out.write(this._buf);
                    if (len < 0) {
                    } else {
                        if (len > 0) {
                            this.skip(len);
                            loop = 0;
                            continue;
                        }
                        if (loop++ <= 1) continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                this._out = null;
                this._outStream = null;
                throw e;
            }
            finally {
                if (this._out != null && !this._out.isOpen()) {
                    this._out = null;
                    this._outStream = null;
                }
                this._buf.position(0);
                this._buf.limit(this._buf.capacity());
            }
        }
    }
}

