/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.seleniumhq.jetty7.client.AbstractHttpConnection;
import org.seleniumhq.jetty7.client.HttpExchange;
import org.seleniumhq.jetty7.io.Buffer;
import org.seleniumhq.jetty7.io.Buffers;
import org.seleniumhq.jetty7.io.Connection;
import org.seleniumhq.jetty7.io.EndPoint;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;

public class BlockingHttpConnection
extends AbstractHttpConnection {
    private static final Logger LOG = Log.getLogger(BlockingHttpConnection.class);
    private boolean _requestComplete;
    private Buffer _requestContentChunk;

    BlockingHttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endPoint) {
        super(requestBuffers, responseBuffers, endPoint);
    }

    protected void reset() throws IOException {
        this._requestComplete = false;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection handle() throws IOException {
        Connection connection = this;
        try {
            boolean failed = false;
            while (this._endp.isOpen() && connection == this) {
                Connection switched;
                BlockingHttpConnection blockingHttpConnection;
                boolean persistent;
                boolean complete;
                Object var9_8;
                HttpExchange exchange;
                LOG.debug("open={} more={}", this._endp.isOpen(), this._parser.isMoreInBuffer());
                BlockingHttpConnection blockingHttpConnection2 = this;
                synchronized (blockingHttpConnection2) {
                    exchange = this._exchange;
                    while (exchange == null) {
                        try {
                            this.wait();
                            exchange = this._exchange;
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                }
                LOG.debug("exchange {}", exchange);
                try {
                    try {
                        if (!this._generator.isCommitted() && exchange != null && exchange.getStatus() == 2) {
                            LOG.debug("commit", new Object[0]);
                            this.commitRequest();
                        }
                        while (this._generator.isCommitted() && !this._generator.isComplete()) {
                            if (this._generator.flushBuffer() > 0) {
                                LOG.debug("flushed", new Object[0]);
                            }
                            if (!this._generator.isState(2)) continue;
                            if (this._requestContentChunk == null) {
                                this._requestContentChunk = exchange.getRequestContentChunk(null);
                            }
                            if (this._requestContentChunk == null) {
                                LOG.debug("complete", new Object[0]);
                                this._generator.complete();
                                continue;
                            }
                            if (!this._generator.isEmpty()) continue;
                            LOG.debug("addChunk", new Object[0]);
                            Buffer chunk = this._requestContentChunk;
                            this._requestContentChunk = exchange.getRequestContentChunk(null);
                            this._generator.addContent(chunk, this._requestContentChunk == null);
                        }
                        if (this._generator.isComplete() && !this._requestComplete) {
                            LOG.debug("requestComplete", new Object[0]);
                            this._requestComplete = true;
                            exchange.getEventListener().onRequestComplete();
                        }
                        if (!this._parser.isComplete() && this._parser.parseAvailable()) {
                            LOG.debug("parsed", new Object[0]);
                        }
                        this._endp.flush();
                    }
                    catch (Throwable e) {
                        LOG.debug("Failure on " + this._exchange, e);
                        failed = true;
                        BlockingHttpConnection blockingHttpConnection3 = this;
                        synchronized (blockingHttpConnection3) {
                            if (exchange != null) {
                                if (exchange.getStatus() != 10 && exchange.getStatus() != 11 && !exchange.isDone() && exchange.setStatus(9)) {
                                    exchange.getEventListener().onException(e);
                                }
                            } else {
                                if (e instanceof IOException) {
                                    throw (IOException)e;
                                }
                                if (e instanceof Error) {
                                    throw (Error)e;
                                }
                                if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                                throw (RuntimeException)e;
                            }
                        }
                        var9_8 = null;
                        LOG.debug("{} {}", this._generator, this._parser);
                        LOG.debug("{}", this._endp);
                        complete = failed || this._generator.isComplete() && this._parser.isComplete();
                        if (!complete) continue;
                        persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                        this._generator.setPersistent(persistent);
                        this.reset();
                        if (persistent) {
                            this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                        }
                        blockingHttpConnection = this;
                        synchronized (blockingHttpConnection) {
                            exchange = this._exchange;
                            this._exchange = null;
                            if (exchange != null) {
                                exchange.cancelTimeout(this._destination.getHttpClient());
                            }
                            if (this._status == 101) {
                                switched = exchange.onSwitchProtocol(this._endp);
                                if (switched != null) {
                                    connection = switched;
                                }
                                this._pipeline = null;
                                if (this._pipeline != null) {
                                    this._destination.send(this._pipeline);
                                }
                                this._pipeline = null;
                                connection = switched;
                            }
                            if (this._pipeline != null) {
                                if (!persistent || connection != this) {
                                    this._destination.send(this._pipeline);
                                } else {
                                    this._exchange = this._pipeline;
                                }
                                this._pipeline = null;
                            }
                            if (this._exchange == null && !this.isReserved()) {
                                this._destination.returnConnection(this, !persistent);
                            }
                            continue;
                        }
                    }
                    var9_8 = null;
                }
                catch (Throwable throwable) {
                    var9_8 = null;
                    LOG.debug("{} {}", this._generator, this._parser);
                    LOG.debug("{}", this._endp);
                    complete = failed || this._generator.isComplete() && this._parser.isComplete();
                    if (!complete) throw throwable;
                    persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                    this._generator.setPersistent(persistent);
                    this.reset();
                    if (persistent) {
                        this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                    }
                    blockingHttpConnection = this;
                    synchronized (blockingHttpConnection) {
                        exchange = this._exchange;
                        this._exchange = null;
                        if (exchange != null) {
                            exchange.cancelTimeout(this._destination.getHttpClient());
                        }
                        if (this._status == 101) {
                            switched = exchange.onSwitchProtocol(this._endp);
                            if (switched != null) {
                                connection = switched;
                            }
                            this._pipeline = null;
                            if (this._pipeline != null) {
                                this._destination.send(this._pipeline);
                            }
                            this._pipeline = null;
                            connection = switched;
                        }
                        if (this._pipeline != null) {
                            if (!persistent || connection != this) {
                                this._destination.send(this._pipeline);
                            } else {
                                this._exchange = this._pipeline;
                            }
                            this._pipeline = null;
                        }
                        if (this._exchange != null) throw throwable;
                        if (this.isReserved()) throw throwable;
                        this._destination.returnConnection(this, !persistent);
                        throw throwable;
                    }
                }
                LOG.debug("{} {}", this._generator, this._parser);
                LOG.debug("{}", this._endp);
                complete = failed || this._generator.isComplete() && this._parser.isComplete();
                if (!complete) continue;
                persistent = !failed && this._parser.isPersistent() && this._generator.isPersistent();
                this._generator.setPersistent(persistent);
                this.reset();
                if (persistent) {
                    this._endp.setMaxIdleTime((int)this._destination.getHttpClient().getIdleTimeout());
                }
                blockingHttpConnection = this;
                synchronized (blockingHttpConnection) {
                    exchange = this._exchange;
                    this._exchange = null;
                    if (exchange != null) {
                        exchange.cancelTimeout(this._destination.getHttpClient());
                    }
                    if (this._status == 101) {
                        switched = exchange.onSwitchProtocol(this._endp);
                        if (switched != null) {
                            connection = switched;
                        }
                        this._pipeline = null;
                        if (this._pipeline != null) {
                            this._destination.send(this._pipeline);
                        }
                        this._pipeline = null;
                        connection = switched;
                    }
                    if (this._pipeline != null) {
                        if (!persistent || connection != this) {
                            this._destination.send(this._pipeline);
                        } else {
                            this._exchange = this._pipeline;
                        }
                        this._pipeline = null;
                    }
                    if (this._exchange == null && !this.isReserved()) {
                        this._destination.returnConnection(this, !persistent);
                    }
                }
            }
            Object var16_14 = null;
            this._parser.returnBuffers();
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            this._parser.returnBuffers();
            this._generator.returnBuffers();
            throw throwable;
        }
        this._generator.returnBuffers();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        boolean sent = super.send(ex);
        if (sent) {
            BlockingHttpConnection blockingHttpConnection = this;
            synchronized (blockingHttpConnection) {
                this.notifyAll();
            }
        }
        return sent;
    }
}

