/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ShortTermMemoryHandler
extends Handler {
    private final LogRecord[] lastRecords;
    private final int capacity;
    private final Formatter formatter;
    private int minimumLevel;
    private int currentIndex;

    public ShortTermMemoryHandler(int capacity, Level minimumLevel, Formatter formatter) {
        this.capacity = capacity;
        this.formatter = formatter;
        this.minimumLevel = minimumLevel.intValue();
        this.lastRecords = new LogRecord[capacity];
        this.currentIndex = 0;
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < this.minimumLevel) {
            return;
        }
        this.lastRecords[this.currentIndex] = record;
        ++this.currentIndex;
        if (this.currentIndex >= this.capacity) {
            this.currentIndex = 0;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        int i = 0;
        while (i < this.capacity) {
            this.lastRecords[i] = null;
            ++i;
        }
    }

    public synchronized LogRecord[] records() {
        ArrayList<LogRecord> validRecords = new ArrayList<LogRecord>(this.capacity);
        int i = this.currentIndex;
        while (i < this.capacity) {
            if (this.lastRecords[i] != null) {
                validRecords.add(this.lastRecords[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.currentIndex) {
            if (this.lastRecords[i] != null) {
                validRecords.add(this.lastRecords[i]);
            }
            ++i;
        }
        return validRecords.toArray(new LogRecord[validRecords.size()]);
    }

    public String formattedRecords() {
        StringWriter writer = new StringWriter();
        LogRecord[] logRecordArray = this.records();
        int n = logRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogRecord record = logRecordArray[n2];
            writer.append(this.formatter.format(record));
            writer.append("\n");
            ++n2;
        }
        return writer.toString();
    }
}

