/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.lift.find;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.openqa.selenium.lift.find.Finder;

public abstract class BaseFinder<S, T>
implements Finder<S, T> {
    protected List<Matcher<S>> matchers = new ArrayList<Matcher<S>>();

    @Override
    public Collection<S> findFrom(T context) {
        Collection<S> found = this.extractFrom(context);
        if (this.matchers.isEmpty()) {
            return found;
        }
        return this.allMatching(this.matchers, found);
    }

    @Override
    public Finder<S, T> with(Matcher<S> matcher) {
        this.matchers.add(matcher);
        return this;
    }

    @Override
    public void describeTo(Description description) {
        this.describeTargetTo(description);
        for (Matcher<S> matcher : this.matchers) {
            if (matcher == null) continue;
            description.appendText(" with ");
            matcher.describeTo(description);
        }
    }

    protected abstract Collection<S> extractFrom(T var1);

    protected abstract void describeTargetTo(Description var1);

    protected Collection<S> allMatching(List<Matcher<S>> matchers, Collection<S> items) {
        ArrayList<S> temp = new ArrayList<S>();
        for (S item : items) {
            if (!this.allOf(matchers).matches(item)) continue;
            temp.add(item);
        }
        return temp;
    }

    private Matcher<S> allOf(final List<Matcher<S>> matcherList) {
        return new TypeSafeMatcher<S>(){

            @Override
            public boolean matchesSafely(S item) {
                for (Matcher matcher : matcherList) {
                    if (matcher.matches(item)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void describeTo(Description description) {
                for (Matcher matcher : matcherList) {
                    matcher.describeTo(description);
                }
            }
        };
    }
}

