/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;

public class SwitchToFrame
implements SeleneseFunction<Void> {
    @Override
    public Void apply(Selenium selenium, Map<String, ?> args) {
        block6: {
            Object id = args.get("id");
            if (id == null) {
                selenium.selectFrame("relative=top");
                return null;
            }
            try {
                if (id instanceof Number) {
                    selenium.selectFrame("index=" + ((Number)id).longValue());
                    break block6;
                }
                if (id instanceof String) {
                    selenium.selectFrame((String)id);
                    break block6;
                }
                if (id instanceof Map) {
                    String locator = this.getLocator((Map)id);
                    selenium.selectFrame(locator);
                    break block6;
                }
                throw new IllegalArgumentException("Illegal frame switch target: (" + id.getClass().getName() + ") " + id);
            }
            catch (SeleniumException e) {
                throw new NoSuchFrameException(e.getMessage(), e);
            }
        }
        return null;
    }

    private String getLocator(Map<String, ?> elementMap) {
        if (elementMap.containsKey("ELEMENT")) {
            try {
                return URLDecoder.decode((String)elementMap.get("ELEMENT"), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new WebDriverException(e);
            }
        }
        throw new IllegalArgumentException("Map does not define a WebElement");
    }
}

