/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.google.common.collect.ImmutableMap;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;
import org.openqa.selenium.net.Urls;

public abstract class AbstractElementFinder<T>
implements SeleneseFunction<T> {
    private long implicitlyWait = 0L;

    protected abstract T executeFind(Selenium var1, String var2, String var3, String var4);

    protected abstract T onFailure(String var1, String var2);

    protected Map<String, String> newElement(String key) {
        String locator = "stored=" + Urls.urlEncode(key);
        return ImmutableMap.of("ELEMENT", locator);
    }

    @Override
    public T apply(Selenium selenium, Map<String, ?> args) {
        String how = (String)args.get("using");
        String using = (String)args.get("value");
        String parentLocator = (String)args.get("id");
        if (parentLocator == null) {
            parentLocator = "selenium.browserbot.getDocument()";
        } else {
            try {
                parentLocator = "selenium.browserbot.findElement('" + URLDecoder.decode(parentLocator, "UTF-8") + "')";
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        using = using.replaceAll("'", "\\\\'");
        long startTime = System.currentTimeMillis();
        do {
            try {
                T result = this.executeFind(selenium, how, using, parentLocator);
                if (!(result instanceof List) || ((List)result).size() != 0) {
                    return result;
                }
            }
            catch (SeleniumException seleniumException) {
                AbstractElementFinder.sleepQuietly(200L);
            }
        } while (System.currentTimeMillis() - startTime <= this.implicitlyWait);
        return this.onFailure(how, using);
    }

    private static void sleepQuietly(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {}
    }

    public ImplicitWait implicitlyWait() {
        return new ImplicitWait();
    }

    public class ImplicitWait
    implements SeleneseFunction<Object> {
        @Override
        public Object apply(Selenium selenium, Map<String, ?> args) {
            AbstractElementFinder.this.implicitlyWait = ((Number)args.get("ms")).longValue();
            return null;
        }
    }
}

