/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Lock;

public class SocketLock
implements Lock {
    public static final int DEFAULT_PORT = 7055;
    private static final long DELAY_BETWEEN_SOCKET_CHECKS = 2000L;
    private static final InetSocketAddress localhost = new InetSocketAddress("localhost", 7054);
    private final Socket lockSocket = new Socket();
    private final InetSocketAddress address;

    public SocketLock() {
        this(localhost);
    }

    public SocketLock(int lockPort) {
        this(new InetSocketAddress("localhost", lockPort));
    }

    public SocketLock(InetSocketAddress address) {
        this.address = address;
    }

    @Override
    public void lock(long timeoutInMillis) throws WebDriverException {
        long maxWait = System.currentTimeMillis() + timeoutInMillis;
        do {
            try {
                if (this.isLockFree(this.address)) {
                    return;
                }
                Thread.sleep((long)(2000.0 * Math.random()));
            }
            catch (InterruptedException e) {
                throw new WebDriverException(e);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        } while (System.currentTimeMillis() < maxWait);
        throw new WebDriverException(String.format("Unable to bind to locking port %d within %d ms", this.address.getPort(), timeoutInMillis));
    }

    @Override
    public void unlock() {
        try {
            if (this.lockSocket.isBound()) {
                this.lockSocket.close();
            }
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private boolean isLockFree(InetSocketAddress address) throws IOException {
        try {
            this.lockSocket.bind(address);
            return true;
        }
        catch (BindException bindException) {
            return false;
        }
    }
}

