/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_EXE_PROPERTY = "webdriver.ie.driver";
    public static final String IE_DRIVER_LOGFILE_PROPERTY = "webdriver.ie.driver.logfile";
    public static final String IE_DRIVER_LOGLEVEL_PROPERTY = "webdriver.ie.driver.loglevel";

    private InternetExplorerDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static InternetExplorerDriverService createDefaultService() {
        return new Builder().usingAnyFreePort().build();
    }

    /* synthetic */ InternetExplorerDriverService(File file, int n, ImmutableList immutableList, ImmutableMap immutableMap, InternetExplorerDriverService internetExplorerDriverService) throws IOException {
        this(file, n, immutableList, immutableMap);
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;
        private InternetExplorerDriverLogLevel logLevel;

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull(file);
            InternetExplorerDriverService.checkExecutable(file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument(port >= 0, "Invalid port number: %d", port);
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public Builder withLogLevel(InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public InternetExplorerDriverService build() {
            String level;
            String logFilePath;
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            if (this.exe == null) {
                this.exe = InternetExplorerDriverService.findExecutable("IEDriverServer", InternetExplorerDriverService.IE_DRIVER_EXE_PROPERTY, "http://code.google.com/p/selenium/wiki/InternetExplorerDriver", "http://code.google.com/p/selenium/downloads/list");
            }
            if (this.logFile == null && (logFilePath = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGFILE_PROPERTY)) != null) {
                this.logFile = new File(logFilePath);
            }
            if (this.logLevel == null && (level = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGLEVEL_PROPERTY)) != null) {
                this.logLevel = InternetExplorerDriverLogLevel.valueOf(level);
            }
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add(String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add(String.format("--log-file=%s", this.logFile.getAbsolutePath()));
                }
                if (this.logLevel != null) {
                    argsBuilder.add(String.format("--log-level=%s", this.logLevel.toString()));
                }
                return new InternetExplorerDriverService(this.exe, this.port, (ImmutableList)argsBuilder.build(), this.environment, null);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

