/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class HtmlUnitWebElement
implements WrapsDriver,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByTagName,
FindsByCssSelector,
Locatable,
WebElement {
    protected final HtmlUnitDriver parent;
    protected final HtmlElement element;
    private static final char nbspChar = '\u00a0';
    private static final String[] blockLevelsTagNames = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address", "ul", "ol", "pre", "br"};
    private static final String[] booleanAttributes = new String[]{"async", "autofocus", "autoplay", "checked", "compact", "complete", "controls", "declare", "defaultchecked", "defaultselected", "defer", "disabled", "draggable", "ended", "formnovalidate", "hidden", "indeterminate", "iscontenteditable", "ismap", "itemscope", "loop", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "paused", "pubdate", "readonly", "required", "reversed", "scoped", "seamless", "seeking", "selected", "spellcheck", "truespeed", "willvalidate"};
    private String toString;

    public HtmlUnitWebElement(HtmlUnitDriver parent, HtmlElement element) {
        this.parent = parent;
        this.element = element;
    }

    @Override
    public void click() {
        HtmlElement referencedElement;
        try {
            this.verifyCanInteractWithElement();
        }
        catch (InvalidElementStateException invalidElementStateException) {}
        HtmlUnitMouse mouse = (HtmlUnitMouse)this.parent.getMouse();
        mouse.click(this.getCoordinates());
        if (this.element instanceof HtmlLabel && (referencedElement = ((HtmlLabel)this.element).getReferencedElement()) != null) {
            new HtmlUnitWebElement(this.parent, referencedElement).click();
        }
    }

    @Override
    public void submit() {
        try {
            if (this.element instanceof HtmlForm) {
                this.submitForm((HtmlForm)this.element);
                return;
            }
            if (this.element instanceof HtmlSubmitInput || this.element instanceof HtmlImageInput) {
                this.element.click();
                return;
            }
            if (this.element instanceof HtmlInput) {
                this.submitForm(this.element.getEnclosingForm());
                return;
            }
            WebElement form = this.findParentForm();
            if (form == null) {
                throw new NoSuchElementException("Unable to find the containing form");
            }
            form.submit();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private void submitForm(HtmlForm form) {
        this.assertElementNotStale();
        ArrayList<String> names = new ArrayList<String>();
        names.add("input");
        names.add("button");
        List<HtmlElement> allElements = form.getHtmlElementsByTagNames(names);
        HtmlElement submit = null;
        for (HtmlElement element : allElements) {
            if (!this.isSubmitElement(element) || !this.isBefore(submit)) continue;
            submit = element;
        }
        if (submit == null) {
            if (this.parent.isJavascriptEnabled()) {
                ScriptResult eventResult = form.fireEvent("submit");
                if (!ScriptResult.isFalse(eventResult)) {
                    this.parent.executeScript("arguments[0].submit()", form);
                }
                return;
            }
            throw new WebDriverException("Cannot locate element used to submit form");
        }
        try {
            submit.click();
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
    }

    private boolean isSubmitElement(HtmlElement element) {
        HtmlButton button;
        HtmlElement candidate = null;
        if (element instanceof HtmlSubmitInput && !((HtmlSubmitInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlImageInput && !((HtmlImageInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlButton && "submit".equalsIgnoreCase((button = (HtmlButton)element).getTypeAttribute()) && !button.isDisabled()) {
            candidate = element;
        }
        return candidate != null;
    }

    private boolean isBefore(HtmlElement submit) {
        return submit == null;
    }

    @Override
    public void clear() {
        this.assertElementNotStale();
        if (this.element instanceof HtmlInput) {
            HtmlInput htmlInput = (HtmlInput)this.element;
            if (htmlInput.isReadOnly()) {
                throw new InvalidElementStateException("You may only edit editable elements");
            }
            if (htmlInput.isDisabled()) {
                throw new InvalidElementStateException("You may only interact with enabled elements");
            }
            htmlInput.setValueAttribute("");
        } else if (this.element instanceof HtmlTextArea) {
            HtmlTextArea htmlTextArea = (HtmlTextArea)this.element;
            if (htmlTextArea.isReadOnly()) {
                throw new InvalidElementStateException("You may only edit editable elements");
            }
            if (htmlTextArea.isDisabled()) {
                throw new InvalidElementStateException("You may only interact with enabled elements");
            }
            htmlTextArea.setText("");
        } else if (this.element.getAttribute("contenteditable") != HtmlElement.ATTRIBUTE_NOT_DEFINED) {
            this.element.setTextContent("");
        }
    }

    private void verifyCanInteractWithElement() {
        this.assertElementNotStale();
        Boolean displayed = this.parent.implicitlyWaitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return HtmlUnitWebElement.this.isDisplayed();
            }
        });
        if (displayed == null || !displayed.booleanValue()) {
            throw new ElementNotVisibleException("You may only interact with visible elements");
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("You may only interact with enabled elements");
        }
    }

    private void switchFocusToThisIfNeeded() {
        HtmlUnitWebElement oldActiveElement = (HtmlUnitWebElement)this.parent.switchTo().activeElement();
        boolean jsEnabled = this.parent.isJavascriptEnabled();
        boolean oldActiveEqualsCurrent = oldActiveElement.equals(this);
        try {
            boolean isBody = oldActiveElement.getTagName().toLowerCase().equals("body");
            if (jsEnabled && !oldActiveEqualsCurrent && !isBody) {
                oldActiveElement.element.blur();
            }
        }
        catch (StaleElementReferenceException staleElementReferenceException) {}
        this.element.focus();
    }

    public void sendKeyDownEvent(Keys modifierKey) {
        this.sendSingleKeyEvent(modifierKey, "keydown");
    }

    public void sendKeyUpEvent(Keys modifierKey) {
        this.sendSingleKeyEvent(modifierKey, "keyup");
    }

    private void sendSingleKeyEvent(Keys modifierKey, String eventDescription) {
        this.verifyCanInteractWithElement();
        this.switchFocusToThisIfNeeded();
        HtmlUnitKeyboard keyboard = (HtmlUnitKeyboard)this.parent.getKeyboard();
        keyboard.performSingleKeyAction(this.getElement(), modifierKey, eventDescription);
    }

    @Override
    public void sendKeys(CharSequence ... value) {
        this.verifyCanInteractWithElement();
        InputKeysContainer keysContainer = new InputKeysContainer(this.isInputElement(), value);
        this.switchFocusToThisIfNeeded();
        HtmlUnitKeyboard keyboard = (HtmlUnitKeyboard)this.parent.getKeyboard();
        keyboard.sendKeys(this.element, this.getAttribute("value"), keysContainer);
        if (this.isInputElement() && keysContainer.wasSubmitKeyFound()) {
            this.submit();
        }
    }

    private boolean isInputElement() {
        return this.element instanceof HtmlInput;
    }

    @Override
    public String getTagName() {
        this.assertElementNotStale();
        return this.element.getNodeName();
    }

    @Override
    public String getAttribute(String name) {
        this.assertElementNotStale();
        String lowerName = name.toLowerCase();
        String value = this.element.getAttribute(name);
        if (this.element instanceof HtmlInput && ("selected".equals(lowerName) || "checked".equals(lowerName))) {
            return this.trueOrNull(((HtmlInput)this.element).isChecked());
        }
        if ("href".equals(lowerName) || "src".equals(lowerName)) {
            if (!this.element.hasAttribute(name)) {
                return null;
            }
            String link = this.element.getAttribute(name).trim();
            HtmlPage page = (HtmlPage)this.element.getPage();
            try {
                return page.getFullyQualifiedUrl(link).toString();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if ("disabled".equals(lowerName)) {
            return this.trueOrNull(!this.isEnabled());
        }
        if ("multiple".equals(lowerName) && this.element instanceof HtmlSelect) {
            String multipleAttribute = ((HtmlSelect)this.element).getMultipleAttribute();
            if ("".equals(multipleAttribute)) {
                return this.trueOrNull(this.element.hasAttribute("multiple"));
            }
            return "true";
        }
        String[] stringArray = booleanAttributes;
        int n = booleanAttributes.length;
        int page = 0;
        while (page < n) {
            String booleanAttribute = stringArray[page];
            if (booleanAttribute.equals(lowerName)) {
                return this.trueOrNull(this.element.hasAttribute(lowerName));
            }
            ++page;
        }
        if ("index".equals(lowerName) && this.element instanceof HtmlOption) {
            HtmlSelect select = ((HtmlOption)this.element).getEnclosingSelect();
            List<HtmlOption> allOptions = select.getOptions();
            int i = 0;
            while (i < allOptions.size()) {
                HtmlOption option = select.getOption(i);
                if (this.element.equals(option)) {
                    return String.valueOf(i);
                }
                ++i;
            }
            return null;
        }
        if ("readonly".equalsIgnoreCase(lowerName)) {
            if (this.element instanceof HtmlInput) {
                return this.trueOrNull(((HtmlInput)this.element).isReadOnly());
            }
            if (this.element instanceof HtmlTextArea) {
                return this.trueOrNull("".equals(((HtmlTextArea)this.element).getReadOnlyAttribute()));
            }
            return null;
        }
        if ("value".equals(lowerName)) {
            if (this.element instanceof HtmlTextArea) {
                return ((HtmlTextArea)this.element).getText();
            }
            if (this.element instanceof HtmlOption && !this.element.hasAttribute("value")) {
                return this.element.getTextContent();
            }
            return value == null ? "" : value;
        }
        if (!"".equals(value)) {
            return value;
        }
        if (this.element.hasAttribute(name)) {
            return "";
        }
        return null;
    }

    private String trueOrNull(boolean condition) {
        return condition ? "true" : null;
    }

    @Override
    public boolean isSelected() {
        this.assertElementNotStale();
        if (this.element instanceof HtmlInput) {
            return ((HtmlInput)this.element).isChecked();
        }
        if (this.element instanceof HtmlOption) {
            return ((HtmlOption)this.element).isSelected();
        }
        throw new UnsupportedOperationException("Unable to determine if element is selected. Tag name is: " + this.element.getTagName());
    }

    @Override
    public boolean isEnabled() {
        this.assertElementNotStale();
        return !this.element.hasAttribute("disabled");
    }

    @Override
    public boolean isDisplayed() {
        this.assertElementNotStale();
        if (!this.parent.isJavascriptEnabled()) {
            return true;
        }
        return !(this.element instanceof HtmlHiddenInput) && this.element.isDisplayed();
    }

    @Override
    public Point getLocation() {
        this.assertElementNotStale();
        try {
            return new Point(this.readAndRound("left"), this.readAndRound("top"));
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element", e);
        }
    }

    @Override
    public Dimension getSize() {
        this.assertElementNotStale();
        try {
            int width = this.readAndRound("width");
            int height = this.readAndRound("height");
            return new Dimension(width, height);
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element", e);
        }
    }

    private int readAndRound(String property) {
        String cssValue = this.getCssValue(property).replaceAll("[^0-9\\.]", "");
        if (cssValue.length() == 0) {
            return 5;
        }
        return Math.round(Float.parseFloat(cssValue));
    }

    @Override
    public String getText() {
        this.assertElementNotStale();
        StringBuffer toReturn = new StringBuffer();
        StringBuffer textSoFar = new StringBuffer();
        boolean isPreformatted = this.element instanceof HtmlPreformattedText;
        this.getTextFromNode(this.element, toReturn, textSoFar, isPreformatted);
        String text = String.valueOf(toReturn.toString()) + this.collapseWhitespace(textSoFar);
        if (!isPreformatted) {
            text = text.trim();
        } else if (text.endsWith("\n")) {
            text = text.substring(0, text.length() - 1);
        }
        return text.replace('\u00a0', ' ');
    }

    protected HtmlUnitDriver getParent() {
        return this.parent;
    }

    protected HtmlElement getElement() {
        return this.element;
    }

    private void getTextFromNode(DomNode node, StringBuffer toReturn, StringBuffer textSoFar, boolean isPreformatted) {
        if (node instanceof HtmlScript) {
            return;
        }
        if (isPreformatted) {
            this.getPreformattedText(node, toReturn);
        } else {
            for (DomNode child : node.getChildren()) {
                String textToAdd;
                if (child instanceof HtmlPreformattedText) {
                    if (child.isDisplayed()) {
                        textToAdd = this.collapseWhitespace(textSoFar);
                        if (!" ".equals(textToAdd)) {
                            toReturn.append(textToAdd);
                        }
                        textSoFar.delete(0, textSoFar.length());
                    }
                    this.getTextFromNode(child, toReturn, textSoFar, true);
                    continue;
                }
                if (child instanceof DomText) {
                    if (!child.isDisplayed()) continue;
                    textToAdd = ((DomText)child).getData();
                    textSoFar.append(textToAdd);
                    continue;
                }
                this.getTextFromNode(child, toReturn, textSoFar, false);
            }
        }
        if (this.isBlockLevel(node)) {
            toReturn.append(this.collapseWhitespace(textSoFar).trim()).append("\n");
            textSoFar.delete(0, textSoFar.length());
        }
    }

    private boolean isBlockLevel(DomNode node) {
        if (!(node instanceof HtmlElement)) {
            return false;
        }
        String tagName = ((HtmlElement)node).getTagName().toLowerCase();
        String[] stringArray = blockLevelsTagNames;
        int n = blockLevelsTagNames.length;
        int n2 = 0;
        while (n2 < n) {
            String blockLevelsTagName = stringArray[n2];
            if (blockLevelsTagName.equals(tagName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String collapseWhitespace(StringBuffer textSoFar) {
        String textToAdd = textSoFar.toString();
        return textToAdd.replaceAll("\\p{javaWhitespace}+", " ").replaceAll("\r", "");
    }

    private void getPreformattedText(DomNode node, StringBuffer toReturn) {
        if (node.isDisplayed()) {
            toReturn.append(node.getTextContent());
        }
    }

    public List<WebElement> getElementsByTagName(String tagName) {
        this.assertElementNotStale();
        List<?> allChildren = this.element.getByXPath(".//" + tagName);
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object o : allChildren) {
            if (!(o instanceof HtmlElement)) continue;
            HtmlElement child = (HtmlElement)o;
            elements.add(this.getParent().newHtmlUnitWebElement(child));
        }
        return elements;
    }

    @Override
    public WebElement findElement(By by) {
        this.assertElementNotStale();
        return this.parent.findElement(by, this);
    }

    @Override
    public List<WebElement> findElements(By by) {
        this.assertElementNotStale();
        return this.parent.findElements(by, this);
    }

    @Override
    public WebElement findElementById(String id) {
        this.assertElementNotStale();
        return this.findElementByXPath(".//*[@id = '" + id + "']");
    }

    @Override
    public List<WebElement> findElementsById(String id) {
        this.assertElementNotStale();
        return this.findElementsByXPath(".//*[@id = '" + id + "']");
    }

    @Override
    public List<WebElement> findElementsByCssSelector(String using) {
        List<WebElement> allElements = this.parent.findElementsByCssSelector(using);
        return this.findChildNodes(allElements);
    }

    @Override
    public WebElement findElementByCssSelector(String using) {
        List<WebElement> allElements = this.parent.findElementsByCssSelector(using);
        if ((allElements = this.findChildNodes(allElements)).isEmpty()) {
            throw new NoSuchElementException("Cannot find child element using css: " + using);
        }
        return allElements.get(0);
    }

    private List<WebElement> findChildNodes(List<WebElement> allElements) {
        LinkedList<WebElement> toReturn = new LinkedList<WebElement>();
        for (WebElement current : allElements) {
            HtmlElement candidate = ((HtmlUnitWebElement)current).element;
            if (!this.element.isAncestorOf(candidate) || this.element == candidate) continue;
            toReturn.add(current);
        }
        return toReturn;
    }

    @Override
    public WebElement findElementByXPath(String xpathExpr) {
        Object node;
        this.assertElementNotStale();
        try {
            node = this.element.getFirstByXPath(xpathExpr);
        }
        catch (Exception ex) {
            throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", xpathExpr), ex);
        }
        if (node == null) {
            throw new NoSuchElementException("Unable to find an element with xpath " + xpathExpr);
        }
        if (node instanceof HtmlElement) {
            return this.getParent().newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", xpathExpr, node.getClass().toString()));
    }

    @Override
    public List<WebElement> findElementsByXPath(String xpathExpr) {
        List<?> htmlElements;
        this.assertElementNotStale();
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        try {
            htmlElements = this.element.getByXPath(xpathExpr);
        }
        catch (Exception ex) {
            throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", xpathExpr), ex);
        }
        for (Object e : htmlElements) {
            if (e instanceof HtmlElement) {
                webElements.add(this.getParent().newHtmlUnitWebElement((HtmlElement)e));
                continue;
            }
            throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", xpathExpr, e.getClass().toString()));
        }
        return webElements;
    }

    @Override
    public WebElement findElementByLinkText(String linkText) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByLinkText(linkText);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.get(0);
    }

    @Override
    public List<WebElement> findElementsByLinkText(String linkText) {
        this.assertElementNotStale();
        String expectedText = linkText.trim();
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!expectedText.equals(e.getTextContent().trim()) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    @Override
    public WebElement findElementByPartialLinkText(String linkText) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByPartialLinkText(linkText);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.size() > 0 ? elements.get(0) : null;
    }

    @Override
    public List<WebElement> findElementsByPartialLinkText(String linkText) {
        this.assertElementNotStale();
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!e.getTextContent().contains(linkText) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    @Override
    public WebElement findElementByTagName(String name) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByTagName(name);
        if (elements.isEmpty()) {
            throw new NoSuchElementException("Cannot find element with tag name: " + name);
        }
        return elements.get(0);
    }

    @Override
    public List<WebElement> findElementsByTagName(String name) {
        this.assertElementNotStale();
        List elements = this.element.getHtmlElementsByTagName(name);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(elements.size());
        for (HtmlElement element : elements) {
            toReturn.add(this.parent.newHtmlUnitWebElement(element));
        }
        return toReturn;
    }

    private WebElement findParentForm() {
        DomNode current = this.element;
        while (current != null && !(current instanceof HtmlForm)) {
            current = current.getParentNode();
        }
        return this.getParent().newHtmlUnitWebElement((HtmlForm)current);
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('<').append(this.element.getTagName());
            NamedNodeMap attributes = this.element.getAttributes();
            int n = attributes.getLength();
            int i = 0;
            while (i < n) {
                Attr a = (Attr)attributes.item(i);
                sb.append(' ').append(a.getName()).append("=\"").append(a.getValue().replace("\"", "&quot;")).append("\"");
                ++i;
            }
            if (this.element.hasChildNodes()) {
                sb.append('>');
            } else {
                sb.append(" />");
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }

    protected void assertElementNotStale() {
        SgmlPage elementPage = this.element.getPage();
        Page currentPage = this.parent.lastPage();
        if (!currentPage.equals(elementPage)) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        DomNode parentElement = this.element;
        while (parentElement != null && !(parentElement instanceof HtmlHtml)) {
            parentElement = parentElement.getParentNode();
        }
        if (parentElement == null) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that a user cannot interact with it.");
        }
    }

    @Override
    public String getCssValue(String propertyName) {
        this.assertElementNotStale();
        return this.getEffectiveStyle(this.element, propertyName);
    }

    private String getEffectiveStyle(HtmlElement htmlElement, String propertyName) {
        HtmlElement current = htmlElement;
        String value = "inherit";
        while ("inherit".equals(value)) {
            Object result = this.parent.executeScript("if (window.getComputedStyle) {     return window.getComputedStyle(arguments[0], null).getPropertyValue(arguments[1]); } if (arguments[0].currentStyle) {     return arguments[0].currentStyle[arguments[1]]; } if (window.document.defaultView && window.document.defaultView.getComputedStyle) {     return window.document.defaultView.getComputedStyle(arguments[0], null)[arguments[1]]; } ", current, propertyName);
            if (!(result instanceof Undefined)) {
                value = String.valueOf(result);
            }
            current = (HtmlElement)current.getParentNode();
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        return other instanceof HtmlUnitWebElement && this.element.equals(((HtmlUnitWebElement)other).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    @Override
    @Deprecated
    public Point getLocationOnScreenOnceScrolledIntoView() {
        return this.getLocation();
    }

    @Override
    public Coordinates getCoordinates() {
        return new Coordinates(){

            @Override
            @Deprecated
            public Point getLocationOnScreen() {
                throw new UnsupportedOperationException("Not displayed, no screen location.");
            }

            @Override
            @Deprecated
            public Point getLocationInViewPort() {
                return HtmlUnitWebElement.this.getLocation();
            }

            @Override
            @Deprecated
            public Point getLocationInDOM() {
                return HtmlUnitWebElement.this.getLocation();
            }

            @Override
            public Point onScreen() {
                throw new UnsupportedOperationException("Not displayed, no screen location.");
            }

            @Override
            public Point inViewPort() {
                return HtmlUnitWebElement.this.getLocation();
            }

            @Override
            public Point onPage() {
                return HtmlUnitWebElement.this.getLocation();
            }

            @Override
            public Object getAuxiliary() {
                return HtmlUnitWebElement.this.getElement();
            }
        };
    }
}

